/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.splitfile.AbstractFileSplitter;
import adams.flow.transformer.splitfile.SplitBySize;
import java.io.File;

public class SplitFile
extends AbstractTransformer {
    private static final long serialVersionUID = 1704879993786242375L;
    protected AbstractFileSplitter m_Splitter;

    @Override
    public String globalInfo() {
        return "Splits the file into several smaller files using the specified splitter algorithm.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("splitter", "splitter", new SplitBySize());
    }

    public void setSplitter(AbstractFileSplitter value) {
        this.m_Splitter = value;
        this.reset();
    }

    public AbstractFileSplitter getSplitter() {
        return this.m_Splitter;
    }

    public String splitterTipText() {
        return "The split algorithm to use.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "splitter", this.m_Splitter);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        String[] files = this.m_Splitter.split(file);
        if (!this.m_Stopped) {
            this.m_OutputToken = new Token(files);
        }
        if (!this.m_Stopped && this.isLoggingEnabled()) {
            this.getLogger().info(this.m_InputToken.getPayload() + " -> " + this.m_OutputToken.getPayload());
        }
        return result;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        this.m_Splitter.stopExecution();
    }
}

