/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractStringOperation;

public class StringCut
extends AbstractStringOperation {
    private static final long serialVersionUID = -3687113148170774846L;
    protected boolean m_UseCharacterPos;
    protected int m_CharacterStartPos;
    protected int m_CharacterEndPos;
    protected String m_FieldDelimiter;
    protected Index m_FieldIndex;

    @Override
    public String globalInfo() {
        return "Cuts out a part of a string. The cut can be either specified as a fixed character position or as a field from delimited columns.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-char-pos", "useCharacterPos", false);
        this.m_OptionManager.add("char-start-pos", "characterStartPos", 1);
        this.m_OptionManager.add("char-end-pos", "characterEndPos", 10);
        this.m_OptionManager.add("field-delimiter", "fieldDelimiter", "\\t");
        this.m_OptionManager.add("field-index", "fieldIndex", new Index("1"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FieldIndex = new Index();
    }

    public void setUseCharacterPos(boolean value) {
        this.m_UseCharacterPos = value;
        this.reset();
    }

    public boolean getUseCharacterPos() {
        return this.m_UseCharacterPos;
    }

    public String useCharacterPosTipText() {
        return "If true then fixed character positions are used to extract the data instead of delimited fields.";
    }

    public void setCharacterStartPos(int value) {
        this.m_CharacterStartPos = value;
        this.reset();
    }

    public int getCharacterStartPos() {
        return this.m_CharacterStartPos;
    }

    public String characterStartPosTipText() {
        return "The position of the first character to include in case fixed character positions are used (1-based).";
    }

    public void setCharacterEndPos(int value) {
        this.m_CharacterEndPos = value;
        this.reset();
    }

    public int getCharacterEndPos() {
        return this.m_CharacterEndPos;
    }

    public String characterEndPosTipText() {
        return "The position of the last character to include in case fixed character positions are used (1-based).";
    }

    public void setFieldDelimiter(String value) {
        this.m_FieldDelimiter = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getFieldDelimiter() {
        return Utils.backQuoteChars(this.m_FieldDelimiter);
    }

    public String fieldDelimiterTipText() {
        return "The field delimiter to use; \\t gets automatically converted into its character counterpart.";
    }

    public void setFieldIndex(Index value) {
        this.m_FieldIndex = value;
        this.reset();
    }

    public Index getFieldIndex() {
        return this.m_FieldIndex;
    }

    public String fieldIndexTipText() {
        return "The 1-based index of the field to cut from the string(s).";
    }

    @Override
    public String getQuickInfo() {
        String result;
        if (QuickInfoHelper.hasVariable(this, "useCharacterPos") || this.m_UseCharacterPos) {
            result = QuickInfoHelper.toString((OptionHandler)this, "characterStartPos", this.m_CharacterStartPos);
            result = result + QuickInfoHelper.toString((OptionHandler)this, "characterEndPos", this.m_CharacterEndPos, "-");
        } else {
            result = QuickInfoHelper.toString((OptionHandler)this, "fieldIndex", this.m_FieldIndex, "Index = ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, "fieldDelimiter", this.m_FieldDelimiter, ", Delimiter = ");
        }
        return result;
    }

    @Override
    protected String process(String s) {
        String result;
        if (this.m_UseCharacterPos) {
            int from = this.m_CharacterStartPos - 1;
            int to = this.m_CharacterEndPos;
            if (to > s.length()) {
                to = s.length();
            }
            result = from < s.length() ? s.substring(from, to) : "";
        } else {
            String[] parts = s.split(this.m_FieldDelimiter);
            this.m_FieldIndex.setMax(parts.length);
            result = this.m_FieldIndex.getIntIndex() != -1 && this.m_FieldIndex.getIntIndex() < parts.length ? parts[this.m_FieldIndex.getIntIndex()] : "";
        }
        return result;
    }
}

