/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class StringSplit
extends AbstractTransformer {
    private static final long serialVersionUID = -3687113148170774846L;
    protected BaseRegExp m_Expression;
    protected Delimiter m_Delimiter;

    @Override
    public String globalInfo() {
        return "Splits a string using a regular expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", "\\t");
        this.m_OptionManager.add("delimiter", "delimiter", (Object)Delimiter.DISCARD);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Expression = new BaseRegExp();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "expression", this.m_Expression);
        if (result != null) {
            result = result + " (" + QuickInfoHelper.toString((OptionHandler)this, "delimiter", (Object)this.m_Delimiter) + ")";
        }
        return result;
    }

    public void setExpression(String value) {
        this.m_Expression.setValue(Utils.unbackQuoteChars(value));
        this.reset();
    }

    public String getExpression() {
        return Utils.backQuoteChars(this.m_Expression.getValue());
    }

    public String expressionTipText() {
        return "The regular expression used for splitting the string; \\t\\n\\r\\b\\f get automatically converted into their character counterparts.";
    }

    public void setDelimiter(Delimiter value) {
        this.m_Delimiter = value;
        this.reset();
    }

    public Delimiter getDelimiter() {
        return this.m_Delimiter;
    }

    public String delimiterTipText() {
        return "Defines what to do with the delimiters (= expression).";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            String str = (String)this.m_InputToken.getPayload();
            String[] array = str.split(this.m_Expression.getValue());
            switch (this.m_Delimiter) {
                case DISCARD: {
                    break;
                }
                case APPEND: {
                    for (int i = 0; i < array.length - 1; ++i) {
                        array[i] = array[i] + this.m_Expression.getValue();
                    }
                    break;
                }
                case PREPEND: {
                    for (int i = 1; i < array.length; ++i) {
                        array[i] = this.m_Expression.getValue() + array[i];
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled delimiter action: " + (Object)((Object)this.m_Delimiter));
                }
            }
            this.m_OutputToken = new Token(array);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to split string:", e);
        }
        return result;
    }

    public static enum Delimiter {
        DISCARD,
        APPEND,
        PREPEND;

    }
}

