/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.splitfile;

import adams.core.io.PlaceholderFile;
import adams.flow.transformer.splitfile.AbstractFileSplitter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.logging.Level;

public class SplitByLineCount
extends AbstractFileSplitter {
    private static final long serialVersionUID = -2726373275364150379L;
    protected int m_MaxLines;

    @Override
    public String globalInfo() {
        return "Splits the text file into chunks with the specified maximum of lines.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-lines", "maxLines", 1024, 1, null);
    }

    public void setMaxLines(int value) {
        if (value > 0) {
            this.m_MaxLines = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum number of lines must be >0, provided: " + value);
        }
    }

    public int getMaxLines() {
        return this.m_MaxLines;
    }

    public String maxLinesTipText() {
        return "The maximum number of lines in the generated files.";
    }

    @Override
    protected void doSplit(PlaceholderFile file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            Writer writer = null;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (writer == null) {
                    writer = new BufferedWriter(new FileWriter(this.nextFile().getAbsoluteFile()));
                }
                writer.write(line);
                ((BufferedWriter)writer).newLine();
                if (++count < this.m_MaxLines) continue;
                ((BufferedWriter)writer).flush();
                ((BufferedWriter)writer).close();
                writer = null;
            }
            reader.close();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to split file: " + file, e);
        }
    }
}

