/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Properties;
import adams.core.io.PlaceholderDirectory;
import adams.core.logging.LoggingObject;
import adams.env.Environment;
import adams.gui.chooser.FileChooserBookmark;
import java.util.ArrayList;
import java.util.List;

public class FileChooserBookmarksManger
extends LoggingObject {
    private static final long serialVersionUID = 4461451164139626835L;
    public static final String FILENAME = "FileChooserBookmarks.props";
    public static final String BOOKMARK_COUNT = "BookmarkCount";
    public static final String BOOKMARK_PREFIX_NAME = "BookmarkName.";
    public static final String BOOKMARK_PREFIX_DIR = "BookmarkDir.";
    protected static FileChooserBookmarksManger m_Singleton;
    protected Properties m_Properties;

    protected FileChooserBookmarksManger() {
    }

    public synchronized List<FileChooserBookmark> load() {
        ArrayList<FileChooserBookmark> result = new ArrayList<FileChooserBookmark>();
        Properties props = this.getProperties();
        int count = props.getInteger(BOOKMARK_COUNT, 0);
        for (int i = 0; i < count; ++i) {
            String name = props.getProperty(BOOKMARK_PREFIX_NAME + i);
            PlaceholderDirectory dir = new PlaceholderDirectory(props.getPath(BOOKMARK_PREFIX_DIR + i));
            FileChooserBookmark bookmark = new FileChooserBookmark(name, dir);
            result.add(bookmark);
        }
        return result;
    }

    public synchronized boolean save(List<FileChooserBookmark> bookmarks) {
        Properties props = new Properties();
        props.clear();
        props.setInteger(BOOKMARK_COUNT, bookmarks.size());
        for (int i = 0; i < bookmarks.size(); ++i) {
            FileChooserBookmark bookmark = bookmarks.get(i);
            props.setProperty(BOOKMARK_PREFIX_NAME + i, bookmark.getName());
            props.setPath(BOOKMARK_PREFIX_DIR + i, bookmark.getDirectory().getAbsolutePath());
        }
        boolean result = props.save(Environment.getInstance().createPropertiesFilename(FILENAME));
        this.m_Properties = props;
        return result;
    }

    public synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            try {
                this.m_Properties = Properties.read(FILENAME);
            }
            catch (Exception e) {
                this.m_Properties = new Properties();
            }
        }
        return this.m_Properties;
    }

    public static synchronized FileChooserBookmarksManger getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new FileChooserBookmarksManger();
        }
        return m_Singleton;
    }
}

