/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.gui.core.AbstractRecentItemsHandler;
import java.io.File;
import java.util.HashSet;

public class RecentFilesHandlerWithCommandline<M>
extends AbstractRecentItemsHandler<M, Setup> {
    private static final long serialVersionUID = -8311791192535405075L;
    public static final String RECENTFILES_COUNT = "RecentFilesCount";
    public static final String RECENTFILES_PREFIX = "RecentFile.";
    protected int m_MinNumParentDirs;

    public RecentFilesHandlerWithCommandline(String propsFile, M menu) {
        super(propsFile, menu);
    }

    public RecentFilesHandlerWithCommandline(String propsFile, int maxCount, M menu) {
        super(propsFile, maxCount, menu);
    }

    public RecentFilesHandlerWithCommandline(String propsFile, String propPrefix, int maxCount, M menu) {
        super(propsFile, propPrefix, maxCount, menu);
    }

    @Override
    protected boolean check(Setup item) {
        return item.check();
    }

    protected synchronized int determineMinimumNumberOfParentDirs() {
        HashSet<String> files;
        int i;
        int result = -1;
        int max = 0;
        for (i = 0; i < this.m_RecentItems.size(); ++i) {
            max = Math.max(max, FileUtils.getDirectoryDepth(((Setup)this.m_RecentItems.get(i)).getFile()));
        }
        int num = 0;
        do {
            files = new HashSet<String>();
            for (i = 0; i < this.m_RecentItems.size(); ++i) {
                files.add(FileUtils.createPartialFilename(((Setup)this.m_RecentItems.get(i)).getFile(), num));
            }
            if (files.size() == this.m_RecentItems.size()) {
                result = num;
                continue;
            }
            ++num;
        } while (files.size() < this.m_RecentItems.size() && num <= max);
        return result;
    }

    @Override
    protected String getCountKey() {
        return RECENTFILES_COUNT;
    }

    @Override
    protected String getItemPrefix() {
        return RECENTFILES_PREFIX;
    }

    @Override
    protected String toString(Setup obj) {
        return obj.toString();
    }

    @Override
    protected Setup fromString(String s) {
        return new Setup(s);
    }

    @Override
    protected void preUpdateMenu() {
        super.preUpdateMenu();
        this.m_MinNumParentDirs = this.determineMinimumNumberOfParentDirs();
    }

    @Override
    protected String createMenuItemText(int index, Setup item) {
        return FileUtils.createPartialFilename(item.getFile(), this.m_MinNumParentDirs);
    }

    public static class Setup {
        protected File m_File = null;
        protected Object m_Handler = null;

        public Setup(File file, Object handler) {
            this.m_File = file;
            this.m_Handler = handler;
        }

        public Setup(String s) {
            String[] parts = s.split("\t");
            if (parts.length != 2) {
                return;
            }
            this.m_File = new File(parts[0]);
            try {
                this.m_Handler = OptionUtils.forCommandLine(Object.class, parts[1]);
            }
            catch (Exception e) {
                return;
            }
        }

        public File getFile() {
            return this.m_File;
        }

        public Object getHandler() {
            return this.m_Handler;
        }

        public boolean check() {
            return this.m_File != null && this.m_Handler != null && this.m_File.exists();
        }

        public String toString() {
            return this.m_File.getAbsolutePath() + "\t" + OptionUtils.getCommandLine(this.m_Handler);
        }

        public int hashCode() {
            if (this.m_File != null) {
                return this.m_File.getAbsolutePath().hashCode();
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Setup) {
                return obj.hashCode() == this.hashCode();
            }
            return false;
        }
    }
}

