/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import adams.db.SQLStatement;
import adams.gui.core.AbstractRecentItemsHandler;

public class RecentSQLStatementsHandler<M>
extends AbstractRecentItemsHandler<M, SQLStatement> {
    private static final long serialVersionUID = 7532226757387619342L;
    public static final String RECENTSTATEMENTS_COUNT = "RecentStatementsCount";
    public static final String RECENTSTATEMENTS_PREFIX = "RecentStatement.";

    public RecentSQLStatementsHandler(String propsFile, M menu) {
        super(propsFile, menu);
    }

    public RecentSQLStatementsHandler(String propsFile, int maxCount, M menu) {
        super(propsFile, maxCount, menu);
    }

    public RecentSQLStatementsHandler(String propsFile, String propPrefix, int maxCount, M menu) {
        super(propsFile, propPrefix, maxCount, menu);
    }

    @Override
    protected String getCountKey() {
        return RECENTSTATEMENTS_COUNT;
    }

    @Override
    protected String getItemPrefix() {
        return RECENTSTATEMENTS_PREFIX;
    }

    @Override
    protected String toString(SQLStatement obj) {
        return obj.toString();
    }

    @Override
    protected SQLStatement fromString(String s) {
        return new SQLStatement(s);
    }

    @Override
    protected String createMenuItemText(int index, SQLStatement item) {
        return Utils.shorten(item.getValue().replaceAll("\\s", " "), 40);
    }
}

