/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.gui.chooser.FontChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.PopupMenuCustomizer;
import adams.gui.core.RecentFilesWithEncodingHandler;
import adams.gui.core.TextEditorPanel;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class TextPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -5335911070392516986L;
    public static final String SESSION_FILE = "TextPanelSession.props";
    protected JMenuBar m_MenuBar;
    protected TextEditorPanel m_TextPanel;
    protected JPanel m_PanelInfo;
    protected JLabel m_LabelInfo;
    protected JMenuItem m_MenuItemFileNew;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuFileLoadRecent;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditRedo;
    protected JMenuItem m_MenuItemEditCut;
    protected JMenuItem m_MenuItemEditCopy;
    protected JMenuItem m_MenuItemEditPaste;
    protected JMenuItem m_MenuItemEditSelectAll;
    protected JMenuItem m_MenuItemEditFind;
    protected JMenuItem m_MenuItemEditFindNext;
    protected JMenuItem m_MenuItemViewTabSize;
    protected JMenuItem m_MenuItemViewFont;
    protected JCheckBoxMenuItem m_MenuItemViewLineWrap;
    protected RecentFilesWithEncodingHandler<JMenu> m_RecentFilesHandler;
    protected boolean m_CanOpenFiles;
    protected TitleGenerator m_TitleGenerator;
    protected boolean m_UpdateParentTitle;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_TitleGenerator = new TitleGenerator("Text editor", true);
        this.m_UpdateParentTitle = true;
        this.m_RecentFilesHandler = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelInfo = new JPanel(new FlowLayout(0));
        this.m_PanelInfo.setBackground(Color.WHITE);
        this.m_LabelInfo = new JLabel();
        this.m_PanelInfo.add(this.m_LabelInfo);
        this.add((Component)this.m_PanelInfo, "North");
        this.m_TextPanel = new TextEditorPanel();
        this.m_TextPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextPanel.this.update();
            }
        });
        this.add((Component)this.m_TextPanel, "Center");
        this.setSize(600, 800);
        this.setInfoText(null);
    }

    public void setCanOpenFiles(boolean value) {
        this.m_CanOpenFiles = value;
    }

    public boolean getCanOpenFiles() {
        return this.m_CanOpenFiles;
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
        this.update();
    }

    public String getTitle() {
        return this.m_TitleGenerator.getTitle();
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer<TextEditorPanel> value) {
        this.m_TextPanel.setPopupMenuCustomizer(value);
    }

    public PopupMenuCustomizer<TextEditorPanel> getPopupMenuCustomizer() {
        return this.m_TextPanel.getPopupMenuCustomizer();
    }

    public void setModified(boolean value) {
        this.m_TextPanel.setModified(value);
    }

    public boolean isModified() {
        return this.m_TextPanel.isModified();
    }

    public void setContent(String value) {
        this.m_TextPanel.setContent(value);
    }

    public String getContent() {
        return this.m_TextPanel.getContent();
    }

    public void setInfoText(String value) {
        value = value == null ? "" : value.trim();
        this.m_LabelInfo.setText(value);
        this.m_PanelInfo.setVisible(value.length() > 0);
    }

    public String getInfoText() {
        return this.m_LabelInfo.getText();
    }

    public void setEditable(boolean value) {
        this.m_TextPanel.setEditable(value);
    }

    public boolean isEditable() {
        return this.m_TextPanel.isEditable();
    }

    public void setTextFont(Font value) {
        this.m_TextPanel.setTextFont(value);
    }

    public Font getTextFont() {
        return this.m_TextPanel.getTextFont();
    }

    public void setTabSize(int value) {
        this.m_TextPanel.setTabSize(value);
    }

    public int getTabSize() {
        return this.m_TextPanel.getTabSize();
    }

    public void setLineWrap(boolean value) {
        this.m_TextPanel.setLineWrap(value);
    }

    public boolean getLineWrap() {
        return this.m_TextPanel.getLineWrap();
    }

    public void setCaretPosition(int value) {
        this.m_TextPanel.setCaretPosition(value);
    }

    public int getCaretPosition() {
        return this.m_TextPanel.getCaretPosition();
    }

    protected void addRecentItem() {
        if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentItem(this.m_TextPanel.getCurrentFile().getAbsolutePath() + "\t" + this.m_TextPanel.getCurrentEncoding());
        }
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextPanel.this.updateMenu();
                }
            });
            result.add(menu);
            JMenuItem menuitem = new JMenuItem("New", GUIHelper.getIcon("new.gif"));
            menuitem.setMnemonic('N');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.setContent("");
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileNew = menuitem;
            if (this.m_CanOpenFiles) {
                menuitem = new JMenuItem("Open...", GUIHelper.getIcon("open.gif"));
                menuitem.setMnemonic('O');
                menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TextPanel.this.m_TextPanel.open()) {
                            TextPanel.this.addRecentItem();
                        }
                    }
                });
                menu.add(menuitem);
                this.m_MenuItemFileOpen = menuitem;
                JMenu submenu = new JMenu("Open recent");
                menu.add(submenu);
                this.m_RecentFilesHandler = new RecentFilesWithEncodingHandler<JMenu>(SESSION_FILE, 5, submenu);
                this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, String>(){

                    @Override
                    public void recentItemAdded(RecentItemEvent<JMenu, String> e) {
                    }

                    @Override
                    public void recentItemSelected(RecentItemEvent<JMenu, String> e) {
                        TextPanel.this.open(RecentFilesWithEncodingHandler.getFile(e.getItem()), RecentFilesWithEncodingHandler.getEncoding(e.getItem()));
                    }
                });
                this.m_MenuFileLoadRecent = submenu;
                menuitem = new JMenuItem("Save", GUIHelper.getIcon("save.gif"));
                menuitem.setMnemonic('a');
                menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TextPanel.this.m_TextPanel.save();
                    }
                });
                menu.add(menuitem);
                this.m_MenuItemFileSave = menuitem;
            }
            menuitem = new JMenuItem("Save as...");
            if (!this.m_CanOpenFiles) {
                menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            }
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.saveAs();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileSaveAs = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close", GUIHelper.getIcon("exit.png"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.close();
                }
            });
            menu.add(menuitem);
            menu = new JMenu("Edit");
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextPanel.this.updateMenu();
                }
            });
            result.add(menu);
            menuitem = new JMenuItem("Undo");
            menuitem.setMnemonic('U');
            menuitem.setEnabled(this.m_TextPanel.canUndo());
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Z"));
            menuitem.setIcon(GUIHelper.getIcon("undo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.undo();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditUndo = menuitem;
            menuitem = new JMenuItem("Redo");
            menuitem.setMnemonic('R');
            menuitem.setEnabled(this.m_TextPanel.canUndo());
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Y"));
            menuitem.setIcon(GUIHelper.getIcon("redo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.redo();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditRedo = menuitem;
            menuitem = new JMenuItem("Cut", GUIHelper.getIcon("cut.gif"));
            menuitem.setMnemonic('u');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed X"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.cut();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemEditCut = menuitem;
            menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.copy();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditCopy = menuitem;
            menuitem = new JMenuItem("Paste", GUIHelper.getIcon("paste.gif"));
            menuitem.setMnemonic('P');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed V"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.paste();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditPaste = menuitem;
            menuitem = new JMenuItem("Select all", GUIHelper.getEmptyIcon());
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed A"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.selectAll();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemEditSelectAll = menuitem;
            menuitem = new JMenuItem("Find", GUIHelper.getIcon("find.gif"));
            menuitem.setMnemonic('F');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed F"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.find();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemEditFind = menuitem;
            menuitem = new JMenuItem("Find next", GUIHelper.getEmptyIcon());
            menuitem.setMnemonic('n');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed F"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.findNext();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditFindNext = menuitem;
            menu = new JMenu("View");
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextPanel.this.updateMenu();
                }
            });
            result.add(menu);
            menuitem = new JMenuItem("Tab size...");
            menuitem.setMnemonic('T');
            menuitem.setIcon(GUIHelper.getIcon("text_indent.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String size = JOptionPane.showInputDialog("Please enter new tab size (> 0)", (Object)("" + TextPanel.this.m_TextPanel.getTabSize()));
                    if (size == null) {
                        return;
                    }
                    try {
                        int value = Integer.parseInt(size);
                        if (value <= 0) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TextPanel.this.m_TextPanel.setTabSize(Integer.parseInt(size));
                }
            });
            menu.add(menuitem);
            this.m_MenuItemViewTabSize = menuitem;
            menuitem = new JMenuItem("Font...");
            menuitem.setMnemonic('f');
            menuitem.setIcon(GUIHelper.getIcon("font.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontChooser dialog = TextPanel.this.getParentDialog() != null ? new FontChooser(TextPanel.this.getParentDialog()) : new FontChooser(TextPanel.this.getParentFrame());
                    dialog.setCurrent(TextPanel.this.m_TextPanel.getTextFont());
                    dialog.setLocationRelativeTo(TextPanel.this);
                    dialog.setVisible(true);
                    if (!dialog.getCurrent().equals(TextPanel.this.m_TextPanel.getTextFont())) {
                        TextPanel.this.m_TextPanel.setTextFont(dialog.getCurrent());
                    }
                }
            });
            menu.add(menuitem);
            this.m_MenuItemViewFont = menuitem;
            menuitem = new JCheckBoxMenuItem("Line wrap");
            menuitem.setMnemonic('L');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.setSelected(this.getLineWrap());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextPanel.this.m_TextPanel.setLineWrap(TextPanel.this.m_MenuItemViewLineWrap.isSelected());
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemViewLineWrap = (JCheckBoxMenuItem)menuitem;
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    protected void updateTitle() {
        if (!this.m_UpdateParentTitle) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String title = TextPanel.this.m_TitleGenerator.generate(TextPanel.this.m_TextPanel.getCurrentFile(), TextPanel.this.m_TextPanel.isModified());
                TextPanel.this.setParentTitle(title);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                boolean contentAvailable = TextPanel.this.m_TextPanel.getContent().length() > 0;
                TextPanel.this.m_MenuItemFileNew.setEnabled(TextPanel.this.isEditable() && contentAvailable);
                if (TextPanel.this.m_CanOpenFiles) {
                    TextPanel.this.m_MenuItemFileOpen.setEnabled(TextPanel.this.isEditable());
                    TextPanel.this.m_MenuItemFileSave.setEnabled(contentAvailable && TextPanel.this.isModified());
                }
                TextPanel.this.m_MenuItemFileSaveAs.setEnabled(contentAvailable);
                TextPanel.this.m_MenuItemEditUndo.setEnabled(TextPanel.this.isEditable() && TextPanel.this.m_TextPanel.canUndo());
                TextPanel.this.m_MenuItemEditRedo.setEnabled(TextPanel.this.isEditable() && TextPanel.this.m_TextPanel.canRedo());
                TextPanel.this.m_MenuItemEditCut.setEnabled(TextPanel.this.isEditable() && TextPanel.this.m_TextPanel.canCut());
                TextPanel.this.m_MenuItemEditCopy.setEnabled(TextPanel.this.m_TextPanel.canCopy());
                TextPanel.this.m_MenuItemEditPaste.setEnabled(TextPanel.this.isEditable() && TextPanel.this.m_TextPanel.canPaste());
                TextPanel.this.m_MenuItemEditFind.setEnabled(contentAvailable);
                TextPanel.this.m_MenuItemEditFindNext.setEnabled(contentAvailable && TextPanel.this.m_TextPanel.getLastFind() != null);
                TextPanel.this.m_MenuItemViewLineWrap.setSelected(TextPanel.this.getLineWrap());
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void close() {
        if (this.m_TextPanel.checkForModified()) {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(false);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
        this.closeParent();
    }

    public void open(File file) {
        this.open(file, null);
    }

    public void open(File file, String encoding) {
        if (this.getCanOpenFiles()) {
            if (this.m_TextPanel.open(file, encoding)) {
                this.addRecentItem();
            }
        } else {
            throw new IllegalAccessError("Cannot load files!");
        }
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{String.class, JTextComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{String.class, JTextComponent.class}, cls) && this.m_TextPanel.getContent().length() > 0;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(String.class, cls)) {
            result = this.m_TextPanel.getContent();
            if (((String)result).length() == 0) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTextComponent.class, cls) && this.m_TextPanel.getContent().length() > 0) {
            result = this.m_TextPanel;
        }
        return result;
    }

    public void setUpdateParentTitle(boolean value) {
        this.m_UpdateParentTitle = value;
        if (this.m_UpdateParentTitle) {
            this.updateTitle();
        }
    }

    public boolean getUpdateParentTitle() {
        return this.m_UpdateParentTitle;
    }
}

