/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseAnnotation;
import adams.core.base.BaseObject;
import adams.core.option.AbstractOption;
import adams.flow.processor.ListAnnotationTags;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BaseAnnotationEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
InlineEditorSupport {
    protected BaseTextArea m_TextValue;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseAnnotation)object).stringValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseAnnotation(Utils.unbackQuoteChars(str));
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseAnnotationEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return BaseAnnotationEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + BaseAnnotationEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : BaseAnnotationEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_TextValue = new BaseTextArea(30, 60);
        panelAll.add((Component)new BaseScrollPane(this.m_TextValue), "Center");
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelButtons = new JPanel(new BorderLayout());
        panelAll.add((Component)panelButtons, "South");
        JPanel panel = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panel, "West");
        JButton buttonClear = new JButton("Clear");
        buttonClear.setMnemonic('l');
        buttonClear.setIcon(GUIHelper.getIcon("new.gif"));
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseAnnotationEditor.this.m_TextValue.setText("");
            }
        });
        panel.add(buttonClear);
        final JCheckBox checkLineWrap = new JCheckBox("Line wrap");
        checkLineWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseAnnotationEditor.this.m_TextValue.setLineWrap(checkLineWrap.isSelected());
            }
        });
        panel.add(checkLineWrap);
        panel = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panel, "East");
        JButton buttonHelp = new JButton("Help");
        buttonHelp.setMnemonic('H');
        buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String help = BaseAnnotationEditor.this.getHelpDescription();
                TextDialog dlg = new TextDialog();
                dlg.setDefaultCloseOperation(2);
                dlg.setSize(400, 300);
                dlg.setDialogTitle("Help");
                dlg.setContent(help);
                dlg.setLineWrap(true);
                dlg.setEditable(false);
                dlg.setVisible(true);
            }
        });
        panel.add(buttonHelp);
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = BaseAnnotationEditor.this.m_TextValue.getText();
                if (((BaseAnnotation)BaseAnnotationEditor.this.getValue()).isValid(s) && !s.equals(((BaseObject)BaseAnnotationEditor.this.getValue()).getValue())) {
                    BaseAnnotationEditor.this.setValue(new BaseAnnotation(s));
                }
                BaseAnnotationEditor.this.closeDialog(1);
            }
        });
        panel.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseAnnotationEditor.this.closeDialog(0);
            }
        });
        panel.add(buttonClose);
        return panelAll;
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        this.setValue(new BaseAnnotation(Utils.unbackQuoteChars(value)));
    }

    @Override
    public String getInlineValue() {
        return Utils.backQuoteChars(((BaseAnnotation)this.getValue()).getValue());
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return true;
    }

    @Override
    public String getHelpDescription() {
        return "How to write annotations:\n1. Annotations can be spread over several lines.\n2. You can use custom tags, using the following format:\n!{tagname[:key=value[,key=value...]]}\n3. The 'color' and 'size' keys are automatically interpreted, with 'color' either being a hex string '#ff0000' or a word like 'red' and 'size' being an HTML size ranging from 1 to 7.\n4. You can use the " + ListAnnotationTags.class.getName() + " actor " + "processor to list tags in a flow.";
    }
}

