/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.core.ClassLister;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.print.JComponentWriterFileFilter;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class JComponentWriter
extends AbstractOptionHandler {
    private static final long serialVersionUID = -3764183253552888494L;
    protected transient JComponent m_Component;
    protected boolean m_Enabled;
    protected PlaceholderFile m_OutputFile;
    protected boolean m_UseCustomDimensions;
    protected int m_CustomWidth;
    protected int m_CustomHeight;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("enabled", "enabled", true);
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
        this.m_OptionManager.add("custom-dimensions", "useCustomDimensions", false);
        this.m_OptionManager.add("custom-width", "customWidth", -1);
        this.m_OptionManager.add("custom-height", "customHeight", -1);
    }

    public void setComponent(JComponent c) {
        this.m_Component = c;
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
        this.reset();
    }

    public boolean getEnabled() {
        return this.m_Enabled;
    }

    public String enabledTipText() {
        return "Whether the writer is enabled.";
    }

    public void setFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_OutputFile;
    }

    public String fileTipText() {
        return "The file to save the image to.";
    }

    public abstract String getDescription();

    public abstract String[] getExtensions();

    public void setUseCustomDimensions(boolean value) {
        this.m_UseCustomDimensions = value;
        this.reset();
    }

    public boolean getUseCustomDimensions() {
        return this.m_UseCustomDimensions;
    }

    public String useCustomDimensionsTipText() {
        return "Whether to use custom dimensions or use the component's ones.";
    }

    public void setCustomWidth(int value) {
        this.m_CustomWidth = value;
        this.reset();
    }

    public int getCustomWidth() {
        return this.m_CustomWidth;
    }

    public String customWidthTipText() {
        return "The custom width.";
    }

    public void setCustomHeight(int value) {
        this.m_CustomHeight = value;
        this.reset();
    }

    public int getCustomHeight() {
        return this.m_CustomHeight;
    }

    public String customHeightTipText() {
        return "The custom height.";
    }

    protected abstract void generateOutput() throws Exception;

    public void toOutput() throws Exception {
        if (!this.m_Enabled) {
            return;
        }
        if (this.getFile() == null) {
            throw new Exception("The file is not set!");
        }
        if (this.getFile().isDirectory()) {
            throw new Exception("The file points to a directory: " + this.getFile());
        }
        if (this.getComponent() == null) {
            throw new Exception("The component is not set!");
        }
        if (this.getFile().isDirectory()) {
            return;
        }
        int oldWidth = this.getComponent().getWidth();
        int oldHeight = this.getComponent().getHeight();
        if (this.getUseCustomDimensions()) {
            this.getComponent().setSize(this.getCustomWidth(), this.getCustomHeight());
        }
        this.generateOutput();
        if (this.getUseCustomDimensions()) {
            this.getComponent().setSize(oldWidth, oldHeight);
        }
    }

    public static void toOutput(JComponentWriter writer, JComponent comp, File file) throws Exception {
        JComponentWriter.toOutput(writer, comp, file, -1, -1);
    }

    public static void toOutput(JComponentWriter writer, JComponent comp, File file, int width, int height) throws Exception {
        writer.setComponent(comp);
        writer.setFile(new PlaceholderFile(file));
        if (width != -1 && height != -1) {
            writer.setUseCustomDimensions(true);
            writer.setCustomWidth(width);
            writer.setCustomHeight(height);
        }
        writer.toOutput();
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(JComponentWriter.class);
    }

    public static JComponentWriterFileFilter[] getFileFilters() {
        Vector<JComponentWriterFileFilter> result = new Vector<JComponentWriterFileFilter>();
        Object[] writerNames = JComponentWriter.getWriters();
        Arrays.sort(writerNames);
        for (int i = 0; i < writerNames.length; ++i) {
            try {
                Class<?> cls = Class.forName((String)writerNames[i]);
                JComponentWriter writer = (JComponentWriter)cls.newInstance();
                if (writer.getExtensions().length <= 0) continue;
                JComponentWriterFileFilter filter = new JComponentWriterFileFilter(writer.getExtensions(), writer.getDescription(), writer);
                result.add(filter);
                continue;
            }
            catch (Exception e) {
                System.err.println((String)writerNames[i] + ": " + e);
            }
        }
        return result.toArray(new JComponentWriterFileFilter[result.size()]);
    }

    public static JComponentWriter getWriterForFile(File file) {
        return JComponentWriter.getWriterForFile(file.getAbsolutePath());
    }

    public static JComponentWriter getWriterForFile(String filename) {
        return JComponentWriter.getWriterForExtension(filename.replaceAll("^.*\\.", ""));
    }

    public static JComponentWriter getWriterForExtension(String ext) {
        ext = ext.replaceAll("^\\.", "").toLowerCase();
        JComponentWriterFileFilter[] filters = JComponentWriter.getFileFilters();
        JComponentWriter result = null;
        for (int i = 0; i < filters.length; ++i) {
            String[] extensions = filters[i].getExtensions();
            for (int n = 0; n < extensions.length; ++n) {
                if (!extensions[n].toLowerCase().equals(ext)) continue;
                result = filters[i].getWriter();
                break;
            }
            if (result != null) break;
        }
        if (result == null) {
            result = filters[0].getWriter();
        }
        return result;
    }

    public static JComponentWriter forName(String classname, String[] options) {
        JComponentWriter result;
        try {
            result = (JComponentWriter)OptionUtils.forName(JComponentWriter.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static JComponentWriter forCommandLine(String cmdline) {
        return (JComponentWriter)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        String[] writers = JComponentWriter.getWriters();
        for (int i = 0; i < writers.length; ++i) {
            System.out.println(i + 1 + ". " + writers[i]);
        }
        String filename = "hello.png";
        System.out.println(filename + " -> " + JComponentWriter.getWriterForFile(filename).getClass().getName());
        filename = "hello.JPG";
        System.out.println(filename + " -> " + JComponentWriter.getWriterForFile(filename).getClass().getName());
    }
}

