/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.base.BasePassword;
import adams.core.logging.LoggingLevel;
import adams.db.AbstractDatabaseConnection;
import adams.db.GlobalSingletonDatabaseConnection;
import adams.gui.scripting.AbstractDatabaseScriptlet;

public class Connect
extends AbstractDatabaseScriptlet {
    private static final long serialVersionUID = 5029475846064359798L;
    public static final String ACTION = "connect";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected String getOptionsDescription() {
        return "<driver> <URL> <user> [password] [logging-level] [connect-on-startup] [auto-commit]";
    }

    @Override
    public String getDescription() {
        return "Connects to the database.";
    }

    @Override
    public String process(String options) throws Exception {
        boolean connect;
        String[] params = options.split(" ");
        if (params.length < 2 || params.length > 6) {
            return "Wrong connection parameters!";
        }
        AbstractDatabaseConnection conn = this.getDatabaseConnection();
        boolean bl = connect = !conn.isConnected();
        if (!(!conn.isConnected() || conn.getURL().equals(params[0]) && conn.getUser().equals(params[1]))) {
            conn.disconnect();
            connect = true;
        }
        if (connect) {
            if (!(conn instanceof GlobalSingletonDatabaseConnection)) {
                conn = conn.getClone();
                this.getOwner().getOwner().setDatabaseConnection(conn);
            }
            conn.setURL(params[0]);
            conn.setUser(params[1]);
            if (params.length >= 3) {
                conn.setPassword(new BasePassword(params[2]));
            }
            if (params.length >= 4) {
                conn.setLoggingLevel(LoggingLevel.valueOf(params[3]));
            }
            if (params.length >= 5) {
                conn.setConnectOnStartUp(Boolean.parseBoolean(params[4]));
            }
            if (params.length >= 6) {
                conn.setAutoCommit(Boolean.parseBoolean(params[5]));
            }
            conn.connect();
        }
        if (!conn.isConnected()) {
            return "Failed to connect to database!";
        }
        return null;
    }
}

