/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.core.ClassLocator;
import adams.db.AbstractConditions;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.selection.AbstractDatabaseSelectionPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public abstract class AbstractConditionalDatabaseSelectionPanel<T, C extends AbstractConditions>
extends AbstractDatabaseSelectionPanel<T> {
    private static final long serialVersionUID = 6833350757448286729L;
    protected JButton m_ButtonOptions;
    protected C m_Conditions;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Conditions = this.getDefaultConditions();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ButtonOptions = new JButton("Options");
        this.m_ButtonOptions.setMnemonic('p');
        this.m_ButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConditionalDatabaseSelectionPanel.this.showOptions();
            }
        });
        this.m_SearchPanel.addToWidgetsPanel(this.m_ButtonOptions);
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.m_ButtonOptions.setEnabled(value);
    }

    protected abstract C getDefaultConditions();

    protected abstract Class[] getApprovedConditions();

    protected boolean check(AbstractConditions conditions) {
        Class[] classes;
        boolean result = false;
        for (Class cls : classes = this.getApprovedConditions()) {
            if (!ClassLocator.isSubclass(cls, conditions.getClass())) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean getCanChangeConditionsClass() {
        return false;
    }

    protected void showOptions() {
        GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this);
        dialog.getGOEEditor().setCanChangeClassInDialog(this.getCanChangeConditionsClass());
        dialog.getGOEEditor().setClassType(AbstractConditions.class);
        dialog.setCurrent(this.m_Conditions);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            AbstractConditions cond = (AbstractConditions)dialog.getCurrent();
            if (this.getCanChangeConditionsClass()) {
                if (this.check(cond)) {
                    this.m_Conditions = cond;
                    this.refresh();
                } else {
                    GUIHelper.showErrorMessage(this, "Cannot use these conditions!\n" + cond.getClass().getName());
                    this.showOptions();
                }
            } else {
                this.m_Conditions = cond;
            }
        }
    }
}

