/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.ClassLister;
import adams.core.io.FileUtils;
import adams.core.option.AbstractOptionHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class AbstractContentHandler
extends AbstractOptionHandler {
    private static final long serialVersionUID = 2722977281064051787L;
    public static final String MATCH_ALL = "*";
    protected static Hashtable<String, Vector<Class>> m_Relation;

    public abstract String[] getExtensions();

    protected String checkFile(File file) {
        if (!file.exists()) {
            return "File '" + file + "' does not exist!";
        }
        if (file.isDirectory()) {
            return "File '" + file + "' is a directory!";
        }
        return null;
    }

    protected abstract PreviewPanel createPreview(File var1);

    public JPanel getPreview(File file) {
        String msg = this.checkFile(file);
        if (msg == null) {
            return this.createPreview(file);
        }
        this.getLogger().severe(msg);
        return new NoPreviewAvailablePanel();
    }

    public static String[] getHandlers() {
        return ClassLister.getSingleton().getClassnames(AbstractContentHandler.class);
    }

    protected static synchronized Hashtable<String, Vector<Class>> getRelation() {
        if (m_Relation == null) {
            m_Relation = new Hashtable();
            String[] handlers = AbstractContentHandler.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                try {
                    AbstractContentHandler handler = (AbstractContentHandler)Class.forName(handlers[i]).newInstance();
                    String[] extensions = handler.getExtensions();
                    for (int n = 0; n < extensions.length; ++n) {
                        Vector<Class> classes;
                        if (!m_Relation.containsKey(extensions[n])) {
                            m_Relation.put(extensions[n], new Vector());
                        }
                        if ((classes = m_Relation.get(extensions[n])).contains(handler.getClass())) continue;
                        classes.add(handler.getClass());
                    }
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error processing content handler: " + handlers[i]);
                    e.printStackTrace();
                }
            }
        }
        return m_Relation;
    }

    public static boolean hasHandler(File file) {
        return AbstractContentHandler.hasHandler(file.getAbsolutePath());
    }

    public static boolean hasHandler(String filename) {
        String extension = FileUtils.getExtension(filename);
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        if (extension != null) {
            if (AbstractContentHandler.getRelation().containsKey(MATCH_ALL)) {
                return true;
            }
            return AbstractContentHandler.getRelation().containsKey(extension);
        }
        return AbstractContentHandler.getRelation().containsKey(MATCH_ALL);
    }

    public static Vector<Class> getHandlersForFile(File file) {
        return AbstractContentHandler.getHandlersForFile(file.getAbsolutePath());
    }

    public static Vector<Class> getHandlersForFile(String filename) {
        String extension = FileUtils.getExtension(filename);
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        HashSet set = extension != null && AbstractContentHandler.getRelation().containsKey(extension) ? new HashSet(AbstractContentHandler.getRelation().get(extension)) : new HashSet();
        if (AbstractContentHandler.getRelation().containsKey(MATCH_ALL)) {
            set.addAll(AbstractContentHandler.getRelation().get(MATCH_ALL));
        }
        Vector result = set.size() == 0 ? null : new Vector(set);
        return result;
    }
}

