/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.env.Environment;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextPane;
import adams.gui.scripting.SyntaxDocument;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;

public class ScriptHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 4859255638148506547L;

    @Override
    public String globalInfo() {
        return "Displays script files: " + Utils.arrayToString(this.getExtensions());
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"script", "scr"};
    }

    @Override
    protected PreviewPanel createPreview(File file) {
        BaseTextPane textPane = new BaseTextPane();
        Properties props = Environment.getInstance().read("scripting dialog");
        textPane.setDocument(new SyntaxDocument(props));
        List<String> lines = FileUtils.loadFromFile(file);
        textPane.setText(Utils.flatten(lines, "\n"));
        BasePanel result = new BasePanel(new BorderLayout());
        result.add((Component)new BaseScrollPane(textPane), "Center");
        return new PreviewPanel(result, textPane);
    }
}

