/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.visualization.container.AbstractContainerManager;
import java.io.Serializable;

public abstract class AbstractContainer
implements Serializable,
Comparable<AbstractContainer> {
    private static final long serialVersionUID = 8203562082477741415L;
    protected AbstractContainerManager m_Manager;
    protected Comparable m_Payload;
    protected boolean m_Updating;

    protected AbstractContainer(AbstractContainerManager manager, Comparable payload) {
        this.setManager(manager);
        this.setPayload(payload);
        this.initialize();
    }

    protected void initialize() {
        this.m_Updating = false;
    }

    protected void invalidate() {
    }

    public void setManager(AbstractContainerManager value) {
        this.m_Manager = value;
    }

    public AbstractContainerManager getManager() {
        return this.m_Manager;
    }

    public void setPayload(Comparable value) {
        this.invalidate();
        this.m_Payload = value;
        this.postProcessPayload();
    }

    protected void postProcessPayload() {
    }

    public Comparable getPayload() {
        return this.m_Payload;
    }

    public void assign(AbstractContainer c) {
        this.m_Updating = true;
        this.setPayload(c.getPayload());
        this.m_Updating = false;
    }

    public AbstractContainer copy() {
        AbstractContainer result;
        if (this.getManager() != null) {
            result = (AbstractContainer)this.getManager().newContainer(this.getPayload());
            result.assign(this);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public int compareTo(AbstractContainer o) {
        if (o == null) {
            return 1;
        }
        if (this.getPayload() == null || o.getPayload() == null) {
            if (this.getPayload() == null && o.getPayload() == null) {
                return 0;
            }
            if (this.getPayload() == null) {
                return -1;
            }
            return 1;
        }
        return this.getPayload().compareTo(o.getPayload());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractContainer)) {
            return false;
        }
        return this.compareTo((AbstractContainer)o) == 0;
    }

    public String toString() {
        return "" + this.m_Payload;
    }
}

