/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractTickGenerator;

public abstract class AbstractLimitedTickGenerator
extends AbstractTickGenerator {
    private static final long serialVersionUID = 7324989157055747347L;
    protected int m_NumTicks;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-ticks", "numTicks", this.getDefaultNumTicks(), this.getMinNumTicks(), null);
    }

    protected int getDefaultNumTicks() {
        return 10;
    }

    protected int getMinNumTicks() {
        return 1;
    }

    public void setNumTicks(int value) {
        if (value >= this.getMinNumTicks()) {
            this.m_NumTicks = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of ticks must be >=" + this.getMinNumTicks() + ", provided: " + value);
        }
    }

    public int getNumTicks() {
        return this.m_NumTicks;
    }

    public String numTicksTipText() {
        return "The number of ticks to display along the axis.";
    }
}

