/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.core.ClassLister;
import adams.gui.visualization.debug.objecttree.DefaultObjectRenderer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractObjectPlainTextRenderer {
    protected static Hashtable<Class, List<Class>> m_Cache = new Hashtable();
    protected static String[] m_Renderers = null;
    protected static Class[] m_RendererClasses = null;

    protected static synchronized void initRenderers() {
        if (m_Renderers != null) {
            return;
        }
        m_Renderers = ClassLister.getSingleton().getClassnames(AbstractObjectPlainTextRenderer.class);
        m_RendererClasses = new Class[m_Renderers.length];
        for (int i = 0; i < m_Renderers.length; ++i) {
            try {
                AbstractObjectPlainTextRenderer.m_RendererClasses[i] = Class.forName(m_Renderers[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection renderer '" + m_Renderers[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized List<AbstractObjectPlainTextRenderer> getRenderer(Object obj) {
        if (obj != null) {
            return AbstractObjectPlainTextRenderer.getRenderer(obj.getClass());
        }
        return AbstractObjectPlainTextRenderer.getRenderer(Object.class);
    }

    protected static List<AbstractObjectPlainTextRenderer> instantiate(List<Class> renderers) {
        ArrayList<AbstractObjectPlainTextRenderer> result = new ArrayList<AbstractObjectPlainTextRenderer>();
        for (int i = 0; i < renderers.size(); ++i) {
            try {
                result.add((AbstractObjectPlainTextRenderer)renderers.get(i).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection renderer '" + renderers.get(i).getName() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static synchronized List<AbstractObjectPlainTextRenderer> getRenderer(Class cls) {
        AbstractObjectPlainTextRenderer.initRenderers();
        if (m_Cache.containsKey(cls)) {
            return AbstractObjectPlainTextRenderer.instantiate(m_Cache.get(cls));
        }
        ArrayList<Class> renderers = new ArrayList<Class>();
        for (int i = 0; i < m_RendererClasses.length; ++i) {
            if (m_RendererClasses[i] == DefaultObjectRenderer.class) continue;
            try {
                AbstractObjectPlainTextRenderer renderer = (AbstractObjectPlainTextRenderer)m_RendererClasses[i].newInstance();
                if (!renderer.handles(cls)) continue;
                renderers.add(m_RendererClasses[i]);
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection renderer '" + m_RendererClasses[i].getName() + "':");
                e.printStackTrace();
            }
        }
        if (renderers.size() == 0) {
            renderers.add(DefaultObjectRenderer.class);
        }
        m_Cache.put(cls, renderers);
        return AbstractObjectPlainTextRenderer.instantiate(renderers);
    }

    public abstract boolean handles(Class var1);

    protected abstract String doRender(Object var1);

    public String render(Object obj) {
        if (obj == null) {
            return "null";
        }
        return this.doRender(obj);
    }

    public static String[] getRenderers() {
        return ClassLister.getSingleton().getClassnames(AbstractObjectPlainTextRenderer.class);
    }
}

