/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.gui.core.BaseTreeNode;
import adams.gui.visualization.debug.objecttree.AbstractObjectPlainTextRenderer;
import java.util.ArrayList;

public class Node
extends BaseTreeNode {
    private static final long serialVersionUID = 39921763469189066L;
    protected String m_Property;
    protected NodeType m_NodeType;

    public Node(String property, Object obj) {
        this(property, obj, NodeType.NORMAL);
    }

    public Node(String property, Object obj, NodeType type) {
        super(obj);
        this.m_Property = property;
        this.m_NodeType = type;
    }

    public String getProperty() {
        return this.m_Property;
    }

    public NodeType getNodeType() {
        return this.m_NodeType;
    }

    public boolean isArray() {
        return this.getUserObject().getClass().isArray();
    }

    public String toRepresentation() {
        if (this.getUserObject() == null) {
            return "null";
        }
        AbstractObjectPlainTextRenderer renderer = AbstractObjectPlainTextRenderer.getRenderer(this.getUserObject()).get(0);
        return renderer.render(this.getUserObject());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        if (this.m_Property == null) {
            result.append("this");
        } else {
            result.append(this.m_Property);
        }
        result.append(" <font color=\"gray\">[");
        if (this.getUserObject() != null) {
            String levels = "";
            Class<?> cls = this.getUserObject().getClass();
            while (cls.isArray()) {
                levels = levels + "[]";
                cls = cls.getComponentType();
            }
            result.append(cls.getName());
            result.append(levels);
        } else {
            result.append("null");
        }
        result.append("]</font>");
        result.append("</html>");
        return result.toString();
    }

    @Override
    public String toPlainText() {
        StringBuilder result = new StringBuilder();
        if (this.m_Property == null) {
            result.append("this");
        } else {
            result.append(this.m_Property);
        }
        result.append(" [");
        String levels = "";
        Class<?> cls = this.getUserObject().getClass();
        while (cls.isArray()) {
            levels = levels + "[]";
            cls = cls.getComponentType();
        }
        result.append(cls.getName());
        result.append(levels);
        result.append("]");
        return result.toString();
    }

    public String[] getPropertyPath() {
        ArrayList<String> result = new ArrayList<String>();
        Node current = this;
        do {
            if (current.getProperty() == null) continue;
            result.add(0, current.getProperty());
        } while ((current = (Node)current.getParent()) != null);
        return result.toArray(new String[result.size()]);
    }

    public static enum NodeType {
        NORMAL,
        ARRAY_ELEMENT,
        HASHCODE;

    }
}

