/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.core.option.OptionHandler;
import adams.gui.core.BaseTree;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import adams.gui.visualization.debug.objecttree.Node;
import adams.gui.visualization.debug.objecttree.Renderer;
import adams.gui.visualization.debug.propertyextractor.AbstractPropertyExtractor;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class Tree
extends BaseTree {
    private static final long serialVersionUID = -127345486742553561L;
    public static final String LABEL_HASHCODE = "hashCode";
    protected transient Object m_Object;
    protected HashSet<Object> m_Inspected;
    protected String m_SearchString = null;
    protected Pattern m_SearchPattern = null;
    protected boolean m_IsRegExp = false;

    public Tree() {
        this.setShowsRootHandles(true);
        this.setRootVisible(true);
        this.setCellRenderer(new Renderer());
        this.buildTree(null);
    }

    protected void buildTree(Object root) {
        DefaultTreeModel model;
        this.m_Inspected = new HashSet();
        if (root == null) {
            model = new DefaultTreeModel(null);
        } else {
            Node rootNode = this.buildTree(null, null, root, Node.NodeType.NORMAL);
            model = new DefaultTreeModel(rootNode);
        }
        this.m_Inspected.clear();
        this.setModel(model);
    }

    protected void addArray(Node parent, Object obj) {
        int len = Array.getLength(obj);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(obj, i);
            if (value != null) {
                this.buildTree(parent, "[" + (i + 1) + "]", value, Node.NodeType.ARRAY_ELEMENT);
                continue;
            }
            Node child = new Node("[" + (i + 1) + "]", null, Node.NodeType.ARRAY_ELEMENT);
            parent.add(child);
        }
    }

    protected boolean isPrimitive(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Short) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        return obj instanceof String;
    }

    protected boolean matches(String label) {
        boolean result = true;
        if (this.m_SearchString != null) {
            result = false;
            result = this.m_SearchPattern != null ? this.m_SearchPattern.matcher(label).matches() : label.indexOf(this.m_SearchString) > -1;
        }
        return result;
    }

    protected Node buildTree(Node parent, String property, Object obj, Node.NodeType type) {
        Node result = new Node(property, obj, type);
        if (parent != null) {
            parent.add(result);
        }
        this.m_Inspected.add(obj);
        if (!this.isPrimitive(obj) && this.matches(LABEL_HASHCODE)) {
            result.add(new Node(LABEL_HASHCODE, obj.hashCode(), Node.NodeType.HASHCODE));
        }
        if (obj.getClass().isArray()) {
            this.addArray(result, obj);
        }
        try {
            AbstractPropertyExtractor extractor = AbstractPropertyExtractor.getExtractor(obj);
            extractor.setCurrent(obj);
            for (int i = 0; i < extractor.size(); ++i) {
                boolean add;
                Object current = extractor.getValue(i);
                if (current == null) continue;
                String label = extractor.getLabel(i);
                boolean bl = add = this.matches(label) || current instanceof OptionHandler || current.getClass().isArray();
                if (!add) continue;
                this.buildTree(result, label, current, Node.NodeType.NORMAL);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to obtain property descriptors for: " + obj);
            e.printStackTrace();
        }
        List<AbstractInspectionHandler> handlers = AbstractInspectionHandler.getHandler(obj);
        for (AbstractInspectionHandler handler : handlers) {
            Hashtable<String, Object> additional = handler.inspect(obj);
            for (String key : additional.keySet()) {
                if (!this.matches(key)) continue;
                this.buildTree(result, key, additional.get(key), Node.NodeType.NORMAL);
            }
        }
        return result;
    }

    public void setObject(Object value) {
        this.m_Object = value;
        this.buildTree(this.m_Object);
    }

    public Object getObject() {
        return this.m_Object;
    }

    protected boolean selectPropertyPath(Node parent, String[] path, int index) {
        boolean result = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node child = (Node)parent.getChildAt(i);
            if (!child.getProperty().equals(path[index])) continue;
            if (index < path.length - 1) {
                result = this.selectPropertyPath(child, path, index + 1);
                continue;
            }
            result = true;
            this.setSelectionPath(new TreePath(child.getPath()));
        }
        return result;
    }

    public boolean selectPropertyPath(String[] path) {
        return this.selectPropertyPath((Node)this.getModel().getRoot(), path, 0);
    }

    public void search(String search, boolean isRegExp) {
        if (search.trim().length() == 0) {
            search = null;
            isRegExp = false;
        }
        this.m_SearchString = search;
        this.m_IsRegExp = isRegExp;
        if (this.m_SearchString != null && this.m_IsRegExp) {
            try {
                this.m_SearchPattern = Pattern.compile(this.m_SearchString);
            }
            catch (Exception e) {
                this.m_SearchPattern = null;
            }
        } else {
            this.m_SearchPattern = null;
        }
        this.buildTree(this.m_Object);
    }
}

