/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.image.ColorPickerPanel;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ColorPickerDialog
extends ApprovalDialog {
    private static final long serialVersionUID = -6333253045301958331L;
    protected ColorPickerPanel m_PanelPicker;

    public ColorPickerDialog(Dialog owner, ImagePanel panel) {
        super(owner, Dialog.ModalityType.MODELESS);
        this.m_PanelPicker.setOwner(panel);
    }

    public ColorPickerDialog(Frame owner, ImagePanel panel) {
        super(owner, false);
        this.m_PanelPicker.setOwner(panel);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setTitle("Pick color");
        this.setApproveVisible(true);
        this.setApproveCaption("Copy");
        this.setApproveMnemonic(111);
        this.setCancelVisible(true);
        this.setDiscardVisible(false);
        this.m_PanelPicker = new ColorPickerPanel();
        this.getContentPane().add((Component)this.m_PanelPicker, "Center");
        this.m_ButtonApprove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(ColorHelper.toHex(ColorPickerDialog.this.m_PanelPicker.getSelectedColor()));
            }
        });
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.pack();
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        this.m_PanelPicker.start();
    }

    @Override
    protected void beforeHide() {
        super.beforeHide();
        this.m_PanelPicker.stop();
    }
}

