/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.ClassLister;
import adams.core.logging.LoggingObject;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.image.ImagePanel;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public abstract class AbstractImageViewerPlugin
extends LoggingObject {
    private static final long serialVersionUID = -8139858776265449470L;
    protected static Hashtable<Class, Object> m_LastSetup = new Hashtable();
    protected ImagePanel m_CurrentPanel;
    protected boolean m_CanceledByUser;

    public abstract String getCaption();

    public String getIconName() {
        return null;
    }

    public ImageIcon getIcon() {
        ImageIcon result = null;
        result = this.getIconName() != null ? (this.getIconName().indexOf("/") > -1 ? GUIHelper.getExternalIcon(this.getIconName()) : GUIHelper.getIcon(this.getIconName())) : GUIHelper.getEmptyIcon();
        return result;
    }

    protected boolean hasLastSetup() {
        return m_LastSetup.containsKey(this.getClass());
    }

    protected Object getLastSetup() {
        return m_LastSetup.get(this.getClass());
    }

    protected void setLastSetup(Object setup) {
        m_LastSetup.put(this.getClass(), setup);
    }

    public boolean getCanceledByUser() {
        return this.m_CanceledByUser;
    }

    public abstract boolean canExecute(ImagePanel var1);

    protected abstract String doExecute();

    protected abstract String createLogEntry();

    protected void log() {
        String msg = this.createLogEntry();
        if (msg != null) {
            this.m_CurrentPanel.log(msg);
        }
    }

    public String execute(ImagePanel panel) {
        this.m_CurrentPanel = panel;
        this.m_CanceledByUser = false;
        String result = this.doExecute();
        if (result == null) {
            this.log();
        }
        return result;
    }

    public static String[] getPlugins() {
        return ClassLister.getSingleton().getClassnames(AbstractImageViewerPlugin.class);
    }
}

