/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.DotHitDetector;
import adams.gui.visualization.sequence.PaintletWithCustomDataSupport;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class DotPaintlet
extends AbstractXYSequencePaintlet
implements PaintletWithCustomDataSupport {
    private static final long serialVersionUID = -8772546156227148237L;

    @Override
    public String globalInfo() {
        return "Paintlet for simply painting dots at the specified X-Y position.";
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new DotHitDetector(this);
    }

    @Override
    public void drawCustomData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color) {
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        for (int i = 0; i < data.size(); ++i) {
            XYSequencePoint curr = (XYSequencePoint)points.get(i);
            currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
            g.drawLine(currX, currY, currX, currY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawCustomData(g, moment, data, this.getColor(i));
                    continue;
                }
            }
        }
    }
}

