/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Graphics;

public class MultiPaintlet
extends AbstractXYSequencePaintlet {
    private static final long serialVersionUID = 159999248427405834L;
    protected XYSequencePaintlet[] m_SubPaintlets;

    @Override
    public String globalInfo() {
        return "Combines multiple paintlets.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("paintlet", "subPaintlets", this.getDefaultSubPaintlets());
    }

    protected XYSequencePaintlet[] getDefaultSubPaintlets() {
        return new XYSequencePaintlet[0];
    }

    public void setSubPaintlets(XYSequencePaintlet[] value) {
        this.m_SubPaintlets = value;
        this.setPanel(this.getPanel());
        this.memberChanged();
    }

    public XYSequencePaintlet[] getSubPaintlets() {
        return this.m_SubPaintlets;
    }

    public String subPaintletsTipText() {
        return "The paintlets to combine.";
    }

    @Override
    public void setPanel(PaintablePanel value) {
        super.setPanel(value);
        for (XYSequencePaintlet paintlet : this.m_SubPaintlets) {
            paintlet.setPanel(value);
        }
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.MULTIPLE;
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        for (XYSequencePaintlet paintlet : this.m_SubPaintlets) {
            if (!paintlet.canPaint(moment)) continue;
            paintlet.performPaint(g, moment);
        }
    }
}

