/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.output.MetaFileWriter;
import adams.data.io.output.MultiSheetSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.core.Undo;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanelWithSidePanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.CoordinatesPaintlet;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.axis.FixedLabelTickGenerator;
import adams.gui.visualization.core.plot.AbstractHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.StickPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerList;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceExportDialog;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintletWithFixedXRange;
import adams.gui.visualization.sequence.XYSequencePaintletWithFixedYRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class XYSequencePanel
extends DataContainerPanelWithSidePanel<XYSequence, XYSequenceContainerManager>
implements PaintListener,
ContainerListPopupMenuSupplier<XYSequenceContainerManager, XYSequenceContainer>,
PopupMenuCustomizer,
TipTextCustomizer {
    private static final long serialVersionUID = 7985845939008731534L;
    protected XYSequenceContainerList m_SequenceContainerList;
    protected XYSequencePaintlet m_XYSequencePaintlet;
    protected CoordinatesPaintlet m_CoordinatesPaintlet;
    protected Undo m_Undo;
    protected boolean m_AdjustToVisibleData;
    protected boolean m_AllowResize;
    protected SpreadSheetFileChooser m_FileChooser;
    protected XYSequenceExportDialog m_ExportDialog;
    protected List<SpreadSheetDialog> m_ViewDialogs;

    public XYSequencePanel() {
    }

    public XYSequencePanel(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        this.m_Undo = null;
        this.m_AdjustToVisibleData = true;
        this.m_AllowResize = false;
        super.initialize();
    }

    @Override
    public boolean canHandleFixedLabels() {
        return true;
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    @Override
    protected XYSequenceContainerManager newContainerManager() {
        return new XYSequenceContainerManager(this);
    }

    @Override
    public XYSequencePaintlet getContainerPaintlet() {
        return this.m_XYSequencePaintlet;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.setAdjustToVisibleData(props.getBoolean("Plot.AdjustToVisibleData", false));
        this.m_SequenceContainerList = new XYSequenceContainerList();
        this.m_SequenceContainerList.setManager(this.getContainerManager());
        this.m_SequenceContainerList.setAllowSearch(props.getBoolean("ContainerList.AllowSearch", false));
        this.m_SequenceContainerList.setPopupMenuSupplier(this);
        this.m_SidePanel.setLayout(new GridLayout(1, 1));
        this.m_SidePanel.add(this.m_SequenceContainerList);
        this.getPlot().setPopupMenuCustomizer(this);
        this.getPlot().setTipTextCustomizer(this);
        this.m_XYSequencePaintlet = new StickPaintlet();
        if (this.m_XYSequencePaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)((Object)this.m_XYSequencePaintlet)).setAntiAliasingEnabled(props.getBoolean("Plot.AntiAliasing", true));
        }
        this.m_XYSequencePaintlet.setPanel(this);
        this.setPaintlet((AbstractXYSequencePaintlet)AbstractPaintlet.forCommandLine(props.getPath("Plot.Paintlet", new StickPaintlet().toCommandLine())));
        this.m_CoordinatesPaintlet = new CoordinatesPaintlet();
        this.m_CoordinatesPaintlet.setYInvisible(true);
        this.m_CoordinatesPaintlet.setPanel(this);
        this.m_CoordinatesPaintlet.setXColor(props.getColor("Plot.CoordinatesColor." + (Object)((Object)CoordinatesPaintlet.Coordinates.X), Color.DARK_GRAY));
        this.m_CoordinatesPaintlet.setYColor(props.getColor("Plot.CoordinatesColor." + (Object)((Object)CoordinatesPaintlet.Coordinates.Y), Color.DARK_GRAY));
        try {
            ((XYSequenceContainerManager)this.getContainerManager()).setColorProvider((AbstractColorProvider)OptionUtils.forAnyCommandLine(AbstractColorProvider.class, props.getProperty("Plot.ColorProvider", DefaultColorProvider.class.getName())));
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + " - Failed to set the color provider:");
            ((XYSequenceContainerManager)this.getContainerManager()).setColorProvider(new DefaultColorProvider());
        }
    }

    public AbstractContainerManager getSequenceManager() {
        return this.m_Manager;
    }

    public void setPaintlet(XYSequencePaintlet value) {
        this.removePaintlet(this.m_XYSequencePaintlet);
        this.m_XYSequencePaintlet = value;
        this.m_XYSequencePaintlet.setPanel(this);
        this.update();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_XYSequencePaintlet;
    }

    public void setUndo(Undo value) {
        this.m_Undo = value;
    }

    public Undo getUndo() {
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.m_Undo != null;
    }

    @Override
    protected boolean canPaint(Graphics g) {
        return this.getPlot() != null && this.m_Manager != null;
    }

    public void setAdjustToVisibleData(boolean value) {
        this.m_AdjustToVisibleData = value;
        this.update();
    }

    public boolean getAdjustToVisibleData() {
        return this.m_AdjustToVisibleData;
    }

    @Override
    public void prepareUpdate() {
        XYSequence seq;
        boolean determineYRange = !(this.m_XYSequencePaintlet instanceof XYSequencePaintletWithFixedYRange);
        boolean determineXRange = !(this.m_XYSequencePaintlet instanceof XYSequencePaintletWithFixedXRange);
        boolean isFixedX = false;
        boolean isFixedY = false;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        if (((XYSequenceContainerManager)this.getContainerManager()).countVisible() > 0) {
            double[] keys;
            FixedLabelTickGenerator fixed;
            List<String> labels;
            if (this.getPlot().getAxis(Axis.LEFT).getTickGenerator() instanceof FixedLabelTickGenerator) {
                isFixedY = true;
                seq = ((XYSequenceContainerManager)this.getContainerManager()).getVisible(0).getData();
                labels = seq.getLabelsY();
                fixed = (FixedLabelTickGenerator)this.getPlot().getAxis(Axis.LEFT).getTickGenerator();
                fixed.setLabels(labels);
                if (labels.size() > 0) {
                    keys = seq.getMappingsX().keys();
                    minY = StatUtils.min(keys);
                    maxY = StatUtils.max(keys);
                } else {
                    minY = 0.0;
                    maxY = 1.0;
                }
            }
            if (this.getPlot().getAxis(Axis.BOTTOM).getTickGenerator() instanceof FixedLabelTickGenerator) {
                isFixedX = true;
                seq = ((XYSequenceContainerManager)this.getContainerManager()).getVisible(0).getData();
                labels = seq.getLabelsX();
                fixed = (FixedLabelTickGenerator)this.getPlot().getAxis(Axis.BOTTOM).getTickGenerator();
                fixed.setLabels(labels);
                if (labels.size() > 0) {
                    keys = seq.getMappingsX().keys();
                    minX = StatUtils.min(keys);
                    maxX = StatUtils.max(keys);
                } else {
                    minX = 0.0;
                    maxX = 1.0;
                }
            }
        }
        if (!determineYRange && !isFixedY) {
            minY = ((XYSequencePaintletWithFixedYRange)this.m_XYSequencePaintlet).getMinY();
            maxY = ((XYSequencePaintletWithFixedYRange)this.m_XYSequencePaintlet).getMaxY();
        }
        if (!determineXRange && !isFixedX) {
            minX = ((XYSequencePaintletWithFixedXRange)this.m_XYSequencePaintlet).getMinX();
            maxX = ((XYSequencePaintletWithFixedXRange)this.m_XYSequencePaintlet).getMaxX();
        }
        if (determineXRange || determineYRange) {
            for (int i = 0; i < ((XYSequenceContainerManager)this.getContainerManager()).count(); ++i) {
                if (this.m_AdjustToVisibleData && !((XYSequenceContainerManager)this.getContainerManager()).isVisible(i) || (seq = ((XYSequenceContainer)((XYSequenceContainerManager)this.getContainerManager()).get(i)).getData()).size() == 0) continue;
                if (determineXRange) {
                    minX = Math.min(minX, XYSequencePoint.toDouble(seq.getMinX().getX()));
                    maxX = Math.max(maxX, XYSequencePoint.toDouble(seq.getMaxX().getX()));
                }
                if (!determineYRange) continue;
                minY = Math.min(minY, XYSequencePoint.toDouble(seq.getMinY().getY()));
                maxY = Math.max(maxY, XYSequencePoint.toDouble(seq.getMaxY().getY()));
            }
        }
        if (minX == maxX) {
            minX -= 1.0;
            maxX += 1.0;
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
    }

    @Override
    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem item;
        AntiAliasingSupporter paintlet;
        if (this.m_XYSequencePaintlet instanceof LinePaintlet) {
            paintlet = (LinePaintlet)this.m_XYSequencePaintlet;
            item = new JMenuItem();
            if (!((LinePaintlet)paintlet).isMarkersDisabled()) {
                item.setText("Disable markers");
            } else {
                item.setText("Enable markers");
            }
            item.addActionListener(new ActionListener((LinePaintlet)paintlet){
                final /* synthetic */ LinePaintlet val$paintlet;
                {
                    this.val$paintlet = linePaintlet;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$paintlet.setMarkersDisabled(!this.val$paintlet.isMarkersDisabled());
                    XYSequencePanel.this.repaint();
                }
            });
            menu.add(item);
        }
        if (this.m_XYSequencePaintlet instanceof AntiAliasingSupporter) {
            paintlet = (AntiAliasingSupporter)((Object)this.m_XYSequencePaintlet);
            item = new JMenuItem();
            if (paintlet.isAntiAliasingEnabled()) {
                item.setText("Disable anti-aliasing");
            } else {
                item.setText("Enable anti-aliasing");
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XYSequencePanel.this.setAntiAliasingEnabled(!XYSequencePanel.this.isAntiAliasingEnabled());
                }
            });
            menu.add(item);
        }
        if (this.getAllowResize()) {
            item = new JMenuItem("Resize...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XYSequencePanel.this.showResizeDialog();
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem();
        if (this.isSidePanelVisible()) {
            item.setText("Hide side panel");
        } else {
            item.setText("Show side panel");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.setSidePanelVisible(!XYSequencePanel.this.isSidePanelVisible());
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.m_AdjustToVisibleData) {
            item.setText("Adjust to loaded data");
        } else {
            item.setText("Adjust to visible data");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.m_AdjustToVisibleData = !XYSequencePanel.this.m_AdjustToVisibleData;
                XYSequencePanel.this.update();
            }
        });
        if (!(this.m_XYSequencePaintlet instanceof XYSequencePaintletWithFixedYRange)) {
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem("Save visible sequences...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.saveVisibleSequences();
            }
        });
        menu.add(item);
    }

    @Override
    public JPopupMenu getContainerListPopupMenu(final ContainerTable table, int row) {
        JPopupMenu result = new JPopupMenu();
        final int[] indices = table.getSelectedRows().length == 0 ? new int[]{row} : table.getSelectedRows();
        JMenuItem item = new JMenuItem("Toggle visibility");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < indices.length; ++i) {
                    XYSequenceContainer c;
                    c.setVisible(!(c = (XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(indices[i])).isVisible());
                }
            }
        });
        result.add(item);
        item = new JMenuItem("Choose color...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c;
                String msg = "Choose color";
                XYSequenceContainer cont = null;
                Color color = Color.BLUE;
                if (indices.length == 1) {
                    cont = (XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(indices[0]);
                    msg = msg + " for " + cont.getData().getID();
                    color = cont.getColor();
                }
                if ((c = JColorChooser.showDialog(table, msg, color)) == null) {
                    return;
                }
                for (int i : indices) {
                    ((XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(i)).setColor(c);
                }
            }
        });
        result.add(item);
        if (((XYSequenceContainerManager)this.getContainerManager()).getAllowRemoval()) {
            result.addSeparator();
            item = new JMenuItem("Remove");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XYSequencePanel.this.m_SequenceContainerList.getTable().removeContainers(indices);
                }
            });
            result.add(item);
            item = new JMenuItem("Remove all");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XYSequencePanel.this.m_SequenceContainerList.getTable().removeAllContainers();
                }
            });
            result.add(item);
        }
        result.addSeparator();
        item = new JMenuItem("Save as...");
        item.setEnabled(indices.length == 1);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.saveSequence((XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(indices[0]));
            }
        });
        result.add(item);
        item = new JMenuItem("View as table");
        item.setEnabled(indices.length == 1);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.viewSequence((XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(indices[0]));
            }
        });
        result.add(item);
        return result;
    }

    public void setAntiAliasingEnabled(boolean value) {
        if (this.m_XYSequencePaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)((Object)this.m_XYSequencePaintlet)).setAntiAliasingEnabled(value);
            this.repaint();
        }
    }

    public boolean isAntiAliasingEnabled() {
        if (this.m_XYSequencePaintlet instanceof AntiAliasingSupporter) {
            return ((AntiAliasingSupporter)((Object)this.m_XYSequencePaintlet)).isAntiAliasingEnabled();
        }
        return false;
    }

    protected void saveVisibleSequences() {
        block5: {
            String[] ext;
            SpreadSheetWriter writer;
            block4: {
                if (this.m_ExportDialog == null) {
                    this.m_ExportDialog = this.getParentDialog() != null ? new XYSequenceExportDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new XYSequenceExportDialog(this.getParentFrame(), true);
                }
                this.m_ExportDialog.setLocationRelativeTo(this);
                this.m_ExportDialog.setVisible(true);
                if (this.m_ExportDialog.getOption() != 0) {
                    return;
                }
                writer = (SpreadSheetWriter)this.m_ExportDialog.getExport();
                ext = writer instanceof MetaFileWriter ? ((MetaFileWriter)((Object)writer)).getActualFormatExtensions() : writer.getFormatExtensions();
                if (!(writer instanceof MultiSheetSpreadSheetWriter) || !this.m_ExportDialog.getCombine()) break block4;
                String filename = ((XYSequenceContainerManager)this.getContainerManager()).getVisible(0).getDisplayID() + "_and_" + (((XYSequenceContainerManager)this.getContainerManager()).countVisible() - 1) + "_more";
                filename = FileUtils.createFilename(filename, "");
                filename = this.m_ExportDialog.getDirectory().getAbsolutePath() + File.separator + filename + "." + ext[0];
                ArrayList<SpreadSheet> data = new ArrayList<SpreadSheet>();
                for (int i = 0; i < ((XYSequenceContainerManager)this.getContainerManager()).count(); ++i) {
                    XYSequenceContainer cont = (XYSequenceContainer)((XYSequenceContainerManager)this.getContainerManager()).get(i);
                    if (!cont.isVisible()) continue;
                    data.add(cont.getData().toSpreadSheet());
                }
                if (((MultiSheetSpreadSheetWriter)writer).write(data.toArray(new SpreadSheet[data.size()]), filename)) break block5;
                GUIHelper.showErrorMessage(this, "Failed to write sequence data to '" + filename + "'!");
                break block5;
            }
            String prefix = this.m_ExportDialog.getDirectory().getAbsolutePath();
            for (int i = 0; i < ((XYSequenceContainerManager)this.getContainerManager()).countVisible(); ++i) {
                XYSequence seq = ((XYSequenceContainerManager)this.getContainerManager()).getVisible(i).getData();
                String filename = prefix + File.separator + seq.getID() + "." + ext[0];
                if (writer.write(seq.toSpreadSheet(), filename)) continue;
                GUIHelper.showErrorMessage(this, "Failed to write sequence #" + (i + 1) + " to '" + filename + "'!");
                break;
            }
        }
    }

    protected void saveSequence(XYSequenceContainer cont) {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog(this)) != 0) {
            return;
        }
        XYSequence seq = cont.getData();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(seq.toSpreadSheet(), this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage(this, "Failed to save sequence to file:\n" + this.m_FileChooser.getSelectedFile());
        }
    }

    protected void viewSequence(XYSequenceContainer cont) {
        if (this.m_ViewDialogs == null) {
            this.m_ViewDialogs = new ArrayList<SpreadSheetDialog>();
        }
        SpreadSheetDialog dialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(this.getParentFrame(), false);
        this.m_ViewDialogs.add(dialog);
        dialog.setTitle("Sequence: " + cont.getDisplayID());
        dialog.setSize(400, 600);
        dialog.setLocationRelativeTo(this);
        XYSequence seq = cont.getData();
        dialog.setSpreadSheet(seq.toSpreadSheet());
        dialog.setVisible(true);
    }

    @Override
    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String hit;
        Object detector;
        String result = tiptext;
        MouseEvent event = new MouseEvent(this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        if (this.m_XYSequencePaintlet instanceof HitDetectorSupporter && (detector = ((HitDetectorSupporter)((Object)this.m_XYSequencePaintlet)).getHitDetector()) != null && (hit = (String)((AbstractHitDetector)detector).detect(event)) != null) {
            result = result + hit;
        }
        return result;
    }

    public XYSequenceContainerList getContainerList() {
        return this.m_SequenceContainerList;
    }

    @Override
    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton(this.getDatabaseConnection());
    }

    public void setAllowResize(boolean value) {
        this.m_AllowResize = value;
    }

    public boolean getAllowResize() {
        return this.m_AllowResize;
    }

    protected void showResizeDialog() {
        ApprovalDialog dialog = this.getParentDialog() != null ? ApprovalDialog.getDialog(this.getParentDialog()) : ApprovalDialog.getDialog(this.getParentFrame());
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle("Resizing plot");
        ParameterPanel paramPanel = new ParameterPanel();
        dialog.getContentPane().add((Component)paramPanel, "Center");
        JSpinner spinnerWidth = new JSpinner();
        ((SpinnerNumberModel)spinnerWidth.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)spinnerWidth.getModel()).setStepSize(10);
        ((SpinnerNumberModel)spinnerWidth.getModel()).setValue(this.getPlot().getContent().getWidth());
        paramPanel.addParameter("_Width", spinnerWidth);
        JSpinner spinnerHeight = new JSpinner();
        ((SpinnerNumberModel)spinnerHeight.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)spinnerHeight.getModel()).setStepSize(10);
        ((SpinnerNumberModel)spinnerHeight.getModel()).setValue(this.getPlot().getContent().getHeight());
        paramPanel.addParameter("_Height", spinnerHeight);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            this.resizePlot(new Dimension(((Number)spinnerWidth.getValue()).intValue(), ((Number)spinnerHeight.getValue()).intValue()));
        }
    }

    public void resizePlot(Dimension size) {
        Dimension current = this.getPlot().getContent().getSize();
        int width = size.width - current.width;
        int height = size.height - current.height;
        current = null;
        if (this.getParentDialog() != null) {
            current = this.getParentDialog().getSize();
        } else if (this.getParentFrame() != null) {
            current = this.getParentFrame().getSize();
        } else if (this.getParentInternalFrame() != null) {
            current = this.getParentInternalFrame().getSize();
        }
        if (current != null) {
            Dimension newSize = new Dimension(current.width + width, current.height + height);
            if (this.getParentDialog() != null) {
                this.getParentDialog().setSize(newSize);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setSize(newSize);
            } else if (this.getParentInternalFrame() != null) {
                this.getParentInternalFrame().setSize(newSize);
            }
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_ExportDialog != null) {
            this.m_ExportDialog.dispose();
            this.m_ExportDialog = null;
        }
        if (this.m_ViewDialogs != null) {
            for (SpreadSheetDialog dialog : this.m_ViewDialogs) {
                dialog.dispose();
            }
            this.m_ViewDialogs.clear();
            this.m_ViewDialogs = null;
        }
    }
}

