/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.env.Environment;

public abstract class AbstractExpressionEvaluator<T>
extends AbstractOptionHandler {
    private static final long serialVersionUID = -2158795563625866483L;
    protected String m_Environment;
    protected String m_Expression;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("env", "environment", Environment.class.getName());
        this.m_OptionManager.add("expression", "expression", this.getDefaultExpression());
    }

    public void setEnvironment(String value) {
        this.m_Environment = value;
    }

    public String getEnvironment() {
        return this.m_Environment;
    }

    public String environmentTipText() {
        return "The class to use for determining the environment.";
    }

    protected abstract String getDefaultExpression();

    public void setExpression(String value) {
        this.m_Expression = value;
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public abstract String expressionTipText();

    public abstract T evaluate() throws Exception;

    public static AbstractExpressionEvaluator forName(String classname, String[] options) {
        AbstractExpressionEvaluator result;
        try {
            result = (AbstractExpressionEvaluator)OptionUtils.forName(AbstractExpressionEvaluator.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractExpressionEvaluator forCommandLine(String cmdline) {
        return (AbstractExpressionEvaluator)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static void runEvaluator(Class eval, String[] args) {
        block9: {
            String env = OptionUtils.getOption(args, "-env");
            if (env == null || env.length() == 0) {
                env = Environment.class.getName();
            }
            try {
                Environment.setEnvironmentClass(Class.forName(env));
            }
            catch (Exception e) {
                e.printStackTrace();
                Environment.setEnvironmentClass(Environment.class);
            }
            try {
                if (OptionUtils.helpRequested(args)) {
                    System.out.println("Help requested...\n");
                    AbstractExpressionEvaluator evalInst = AbstractExpressionEvaluator.forName(eval.getName(), new String[0]);
                    System.out.println("\n" + OptionUtils.list(evalInst));
                    break block9;
                }
                AbstractExpressionEvaluator evalInst = AbstractExpressionEvaluator.forName(eval.getName(), args);
                try {
                    Object obj = evalInst.evaluate();
                    if (obj == null) {
                        System.err.println("Failed to generate a result!");
                        break block9;
                    }
                    System.out.println("Result: " + obj);
                }
                catch (Exception e) {
                    System.err.println("Parsing of expression '" + evalInst.getExpression() + "' failed:");
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

