/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import adams.gui.visualization.stats.boxplot.BoxPlotManager;
import java.awt.Color;
import weka.core.Instances;

public class BoxPlot
extends AbstractViewPlugin {
    private static final long serialVersionUID = 9089022183434856748L;
    protected Instances m_Data;

    public String globalInfo() {
        return "Generates box plots for the data.";
    }

    public String getMenuText() {
        return "Box plot";
    }

    public String getMenuIcon() {
        return "boxplot.png";
    }

    protected String check(SpreadSheet sheet) {
        String result = super.check(sheet);
        if (result == null) {
            this.m_Data = null;
            SpreadSheetToWekaInstances convert = new SpreadSheetToWekaInstances();
            convert.setInput((Object)sheet);
            result = convert.convert();
            if (result == null) {
                this.m_Data = (Instances)convert.getOutput();
            }
            convert.cleanUp();
        }
        return result;
    }

    protected BasePanel doGenerate(SpreadSheet sheet) {
        BoxPlotManager result = new BoxPlotManager();
        result.setInstances(this.m_Data);
        result.setNumHorizontal(3);
        result.setFill(true);
        result.setColor(Color.RED);
        result.reset();
        return result;
    }
}

