/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.boxplot;

import adams.data.statistics.StatUtils;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import weka.core.Attribute;
import weka.core.Instances;

public class BoxPlotGraph
extends PlotPanel {
    private static final long serialVersionUID = 3012367720278639818L;
    protected double m_Median;
    protected double m_Lower;
    protected double m_Upper;
    protected double m_Min;
    protected double m_Max;
    protected double[] m_Data;
    protected boolean m_Fill;
    protected Color m_Color;

    protected void initGUI() {
        super.initGUI();
        this.setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
        this.m_AxisLeft.setType(Type.ABSOLUTE);
        this.m_AxisLeft.setTickGenerator((TickGenerator)new FancyTickGenerator());
        this.m_AxisLeft.setNumberFormat("#.##");
        this.m_AxisLeft.setNthValueToShow(2);
        this.m_AxisLeft.setBottomMargin(0.05);
        this.m_AxisLeft.setTopMargin(0.05);
        this.m_AxisLeft.setAxisName(null);
    }

    public void pass(Instances i, Attribute att) {
        int pos = -1;
        for (int t = 0; t < i.numAttributes(); ++t) {
            if (i.attribute(t) != att) continue;
            pos = t;
        }
        this.m_Data = i.attributeToDoubleArray(pos);
        this.m_Median = StatUtils.median((double[])this.m_Data);
        this.m_Min = StatUtils.min((double[])this.m_Data);
        this.m_Max = StatUtils.max((double[])this.m_Data);
        Object[] copyArray = new Double[this.m_Data.length];
        for (int j = 0; j < this.m_Data.length; ++j) {
            copyArray[j] = this.m_Data[j];
        }
        Arrays.sort(copyArray);
        this.m_Lower = (Double)copyArray[(int)Math.round((double)(copyArray.length - 1) * 0.25)];
        this.m_Upper = (Double)copyArray[(int)Math.round((double)(copyArray.length - 1) * 0.75)];
        this.m_AxisLeft.setMinimum(this.m_Min);
        this.m_AxisLeft.setMaximum(this.m_Max);
    }

    public void paintPlot(Graphics g) {
        int maxPos = this.m_AxisLeft.valueToPos(this.m_Max);
        int minPos = this.m_AxisLeft.valueToPos(this.m_Min);
        int medianPos = this.m_AxisLeft.valueToPos(this.m_Median);
        int lowerPos = this.m_AxisLeft.valueToPos(this.m_Lower);
        int upperPos = this.m_AxisLeft.valueToPos(this.m_Upper);
        int wid = this.m_PanelContent.getWidth();
        int widthUse = (int)(0.6 * (double)wid);
        int start = (int)((double)wid * 0.2);
        int midleUse = (int)(0.5 * (double)wid);
        g.setColor(Color.BLACK);
        g.drawLine(midleUse, maxPos, midleUse, minPos);
        g.drawLine((int)((double)wid * 0.4), maxPos, (int)((double)wid * 0.6), maxPos);
        g.drawLine((int)((double)wid * 0.4), minPos, (int)((double)wid * 0.6), minPos);
        g.setColor(Color.GRAY);
        if (this.m_Fill) {
            g.setColor(this.m_Color);
        } else {
            g.setColor(Color.WHITE);
        }
        g.fillRect(start, upperPos, widthUse, lowerPos - upperPos);
        g.setColor(Color.BLACK);
        g.drawRect(start, upperPos, widthUse, lowerPos - upperPos);
        g.drawLine(start, medianPos, start + widthUse, medianPos);
    }

    public void axisSame(double max, double min) {
        this.m_AxisLeft.setMaximum(max);
        this.m_AxisLeft.setMinimum(min);
        this.m_AxisLeft.setBottomMargin(0.0);
        this.m_AxisLeft.setTopMargin(0.0);
    }

    public void setFill(boolean val) {
        this.m_Fill = val;
    }

    public void setColor(Color val) {
        this.m_Color = val;
    }
}

