/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.core.option.OptionUtils;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import java.awt.Graphics;

public abstract class AbstractScatterPlotPaintlet
extends AbstractColorPaintlet
implements AntiAliasingSupporter {
    private static final long serialVersionUID = 7191423312364530577L;
    protected int m_XIndex;
    protected int m_YIndex;
    protected int m_Size;
    protected double[] m_XData;
    protected double[] m_YData;
    protected AxisPanel m_AxisLeft;
    protected AxisPanel m_AxisBottom;
    protected boolean m_AntiAliasingEnabled;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    protected void initialize() {
        super.initialize();
        this.m_XIndex = 0;
        this.m_YIndex = 0;
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Instances != null) {
            this.drawData(g);
        }
    }

    public String toString() {
        return OptionUtils.getCommandLine((Object)((Object)this));
    }

    protected void drawData(Graphics g) {
        if (this.m_Instances != null) {
            g.setColor(this.m_Color);
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            this.m_XData = this.m_Instances.attributeToDoubleArray(this.m_XIndex);
            this.m_YData = this.m_Instances.attributeToDoubleArray(this.m_YIndex);
            this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
        }
    }

    public int getX_Index() {
        return this.m_XIndex;
    }

    public void setX_Index(int val) {
        this.m_XIndex = val;
        this.memberChanged();
    }

    public int getY_Index() {
        return this.m_YIndex;
    }

    public void setY_Index(int val) {
        this.m_YIndex = val;
        this.memberChanged();
    }
}

