/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.blur;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.testing.BoofTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BlurStorageFilter<T extends ImageSingleBand>
implements BlurFilter<T> {
    private Method m;
    private double sigma;
    private int radius;
    private ImageSingleBand storage;
    private boolean hasSigma;
    Class<T> inputType;

    public BlurStorageFilter(String functionName, Class<T> inputType, int radius) {
        this.radius = radius;
        this.inputType = inputType;
        this.hasSigma = false;
        this.m = BoofTesting.findMethod(BlurImageOps.class, functionName, inputType, inputType, Integer.TYPE, inputType);
        if (this.m == null) {
            throw new IllegalArgumentException("Can't find matching function for image type " + inputType.getSimpleName());
        }
    }

    public BlurStorageFilter(String functionName, Class<T> inputType, double sigma, int radius) {
        this.radius = radius;
        this.sigma = sigma;
        this.inputType = inputType;
        this.hasSigma = true;
        this.m = BoofTesting.findMethod(BlurImageOps.class, functionName, inputType, inputType, Double.TYPE, Integer.TYPE, inputType);
        if (this.m == null) {
            throw new IllegalArgumentException("Can't find matching function for image type " + inputType.getSimpleName());
        }
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void process(T input, T output) {
        try {
            if (this.storage == null) {
                this.storage = (ImageSingleBand)((ImageBase)output)._createNew(((ImageSingleBand)output).width, ((ImageSingleBand)output).height);
            } else {
                this.storage.reshape(((ImageSingleBand)output).width, ((ImageSingleBand)output).height);
            }
            if (this.hasSigma) {
                this.m.invoke(null, input, output, this.sigma, this.radius, this.storage);
            } else {
                this.m.invoke(null, input, output, this.radius, this.storage);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public Class<T> getInputType() {
        return this.inputType;
    }
}

