/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.f;

import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.optimization.ResidualsEpipolarMatrix;
import boofcv.alg.geo.ModelObservationResidual;
import boofcv.alg.geo.f.FundamentalResidualSampson;
import boofcv.alg.geo.f.FundamentalResidualSimple;
import boofcv.alg.geo.f.ParamFundamentalEpipolar;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DenseMatrix64F;

public class LeastSquaresFundamental
implements RefineEpipolar {
    ModelCodec<DenseMatrix64F> paramModel;
    ResidualsEpipolarMatrix func;
    double[] param;
    UnconstrainedLeastSquares minimizer;
    int maxIterations;
    double convergenceTol;

    public LeastSquaresFundamental(double convergenceTol, int maxIterations, boolean useSampson) {
        this(new ParamFundamentalEpipolar(), convergenceTol, maxIterations, useSampson);
    }

    public LeastSquaresFundamental(ModelCodec<DenseMatrix64F> paramModel, double convergenceTol, int maxIterations, boolean useSampson) {
        this.paramModel = paramModel;
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.param = new double[paramModel.getParamLength()];
        ModelObservationResidual<DenseMatrix64F, AssociatedPair> residual = useSampson ? new FundamentalResidualSampson() : new FundamentalResidualSimple();
        this.func = new ResidualsEpipolarMatrix(paramModel, residual);
        this.minimizer = FactoryOptimization.leastSquareLevenberg((double)0.001);
    }

    @Override
    public boolean process(DenseMatrix64F F, List<AssociatedPair> obs, DenseMatrix64F refinedF) {
        this.func.setObservations(obs);
        this.paramModel.encode((Object)F, this.param);
        this.minimizer.setFunction((FunctionNtoM)this.func, null);
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)obs.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        this.paramModel.decode(this.minimizer.getParameters(), (Object)refinedF);
        return true;
    }
}

