/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.optimization;

import boofcv.abst.geo.optimization.ModelCodecSwapData;
import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DenseMatrix64F;

public class ResidualsEpipolarMatrixN
implements FunctionNtoM {
    protected ModelCodec<DenseMatrix64F> param;
    protected List<AssociatedPair> obs;
    protected ModelObservationResidualN residual;
    protected DenseMatrix64F F = new DenseMatrix64F(3, 3);

    public ResidualsEpipolarMatrixN(ModelCodec<DenseMatrix64F> param, ModelObservationResidualN residual) {
        this.param = param == null ? new ModelCodecSwapData(9) : param;
        this.residual = residual;
    }

    public void setObservations(List<AssociatedPair> obs) {
        this.obs = obs;
    }

    public int getN() {
        return this.param.getParamLength();
    }

    public int getM() {
        return this.obs.size() * this.residual.getN();
    }

    public void process(double[] input, double[] output) {
        this.param.decode(input, (Object)this.F);
        this.residual.setModel(this.F);
        int index = 0;
        for (int i = 0; i < this.obs.size(); ++i) {
            AssociatedPair p = this.obs.get(i);
            index = this.residual.computeResiduals(p, output, index);
        }
    }
}

