/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.alg.sfm.d3.VisOdomMonoPlaneInfinity;
import boofcv.alg.sfm.robust.DistancePlane2DToPixelSq;
import boofcv.alg.sfm.robust.GenerateSe2_PlanePtPixel;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;

public class MonoPlaneInfinity_to_MonocularPlaneVisualOdometry<T extends ImageBase>
implements MonocularPlaneVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomMonoPlaneInfinity<T> alg;
    DistancePlane2DToPixelSq distance;
    GenerateSe2_PlanePtPixel generator;
    ImageDataType<T> imageType;
    boolean fault;
    Se3_F64 cameraToWorld = new Se3_F64();
    List<PointTrack> active = null;
    Point3D_F64 point3D = new Point3D_F64();

    public MonoPlaneInfinity_to_MonocularPlaneVisualOdometry(VisOdomMonoPlaneInfinity<T> alg, DistancePlane2DToPixelSq distance, GenerateSe2_PlanePtPixel generator, ImageDataType<T> imageType) {
        this.alg = alg;
        this.distance = distance;
        this.generator = generator;
        this.imageType = imageType;
    }

    @Override
    public void setCalibration(MonoPlaneParameters param) {
        this.alg.setIntrinsic(param.intrinsic);
        this.distance.setIntrinsic(param.intrinsic.fx, param.intrinsic.fy, param.intrinsic.skew);
        this.alg.setExtrinsic(param.planeToCamera);
        this.generator.setExtrinsic(param.planeToCamera);
        this.distance.setExtrinsic(param.planeToCamera);
    }

    @Override
    public boolean process(T input) {
        this.active = null;
        this.fault = this.alg.process(input);
        return this.fault;
    }

    @Override
    public ImageDataType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        this.active = null;
        this.alg.reset();
        this.cameraToWorld.reset();
    }

    @Override
    public boolean isFault() {
        return this.fault;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        Se3_F64 worldToCamera = this.alg.getWorldToCurr3D();
        worldToCamera.invert(this.cameraToWorld);
        return this.cameraToWorld;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        this.active.get(index);
        VisOdomMonoPlaneInfinity.VoTrack track = (VisOdomMonoPlaneInfinity.VoTrack)this.active.get(index).getCookie();
        if (track.onPlane) {
            this.point3D.x = -track.ground.y;
            this.point3D.z = track.ground.x;
            this.point3D.y = 0.0;
        } else {
            this.point3D.x = -track.ground.y * 1000.0;
            this.point3D.z = track.ground.x * 1000.0;
            this.point3D.y = 0.0;
        }
        return this.point3D;
    }

    @Override
    public long getTrackId(int index) {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        PointTrack t = this.active.get(index);
        return t.featureId;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        return this.active;
    }

    @Override
    public boolean isInlier(int index) {
        if (this.active == null) {
            this.active = this.alg.getTracker().getActiveTracks(null);
        }
        PointTrack t = this.active.get(index);
        VisOdomMonoPlaneInfinity.VoTrack v = (VisOdomMonoPlaneInfinity.VoTrack)t.getCookie();
        return v.lastInlier == (long)this.alg.getTick();
    }

    @Override
    public boolean isNew(int index) {
        return false;
    }
}

