/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.depth;

import boofcv.alg.distort.RemoveRadialPtoN_F64;
import boofcv.struct.FastQueue;
import boofcv.struct.FastQueueArray_I32;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public class VisualDepthOps {
    public static void depthTo3D(IntrinsicParameters param, ImageUInt16 depth, FastQueue<Point3D_F64> cloud) {
        cloud.reset();
        RemoveRadialPtoN_F64 p2n = new RemoveRadialPtoN_F64();
        p2n.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        Point2D_F64 n = new Point2D_F64();
        for (int y = 0; y < depth.height; ++y) {
            int index = depth.startIndex + y * depth.stride;
            for (int x = 0; x < depth.width; ++x) {
                int mm;
                if ((mm = depth.data[index++] & 0xFFFF) == 0) continue;
                p2n.compute(x, y, n);
                Point3D_F64 p = cloud.grow();
                p.z = mm;
                p.x = n.x * p.z;
                p.y = n.y * p.z;
            }
        }
    }

    public static void depthTo3D(IntrinsicParameters param, MultiSpectral<ImageUInt8> rgb, ImageUInt16 depth, FastQueue<Point3D_F64> cloud, FastQueueArray_I32 cloudColor) {
        cloud.reset();
        cloudColor.reset();
        RemoveRadialPtoN_F64 p2n = new RemoveRadialPtoN_F64();
        p2n.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        Point2D_F64 n = new Point2D_F64();
        ImageUInt8 colorR = rgb.getBand(0);
        ImageUInt8 colorG = rgb.getBand(1);
        ImageUInt8 colorB = rgb.getBand(2);
        for (int y = 0; y < depth.height; ++y) {
            int index = depth.startIndex + y * depth.stride;
            for (int x = 0; x < depth.width; ++x) {
                int mm;
                if ((mm = depth.data[index++] & 0xFFFF) == 0) continue;
                p2n.compute(x, y, n);
                Point3D_F64 p = cloud.grow();
                p.z = mm;
                p.x = n.x * p.z;
                p.y = n.y * p.z;
                int[] color = (int[])cloudColor.grow();
                color[0] = colorR.unsafe_get(x, y);
                color[1] = colorG.unsafe_get(x, y);
                color[2] = colorB.unsafe_get(x, y);
            }
        }
    }
}

