/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.ImageRectangle_F32;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.shapes.Rectangle2D_F32;
import georegression.struct.shapes.Rectangle2D_I32;

public class DistortImageOps {
    public static <T extends ImageBase> void affine(T input, T output, TypeInterpolate interpType, double a11, double a12, double a21, double a22, double dx, double dy) {
        Affine2D_F32 m = new Affine2D_F32();
        m.a11 = (float)a11;
        m.a12 = (float)a12;
        m.a21 = (float)a21;
        m.a22 = (float)a22;
        m.tx = (float)dx;
        m.ty = (float)dy;
        m = m.invert(null);
        PixelTransformAffine_F32 model = new PixelTransformAffine_F32(m);
        if (input instanceof ImageSingleBand) {
            DistortImageOps.distortSingle((ImageSingleBand)input, (ImageSingleBand)output, (PixelTransform_F32)model, false, interpType);
        } else if (input instanceof MultiSpectral) {
            DistortImageOps.distortMS((MultiSpectral)input, (MultiSpectral)output, model, false, interpType);
        }
    }

    public static <T extends ImageSingleBand> void distortSingle(T input, T output, PixelTransform_F32 transform, boolean skipOutsidePixels, TypeInterpolate interpType) {
        Class<?> inputType = input.getClass();
        InterpolatePixel<?> interp = FactoryInterpolation.createPixel(0.0, 255.0, interpType, inputType);
        ImageBorder<?> border = skipOutsidePixels ? null : FactoryImageBorder.value(inputType, 0.0);
        ImageDistort<?> distorter = FactoryDistort.distort(interp, border, inputType);
        distorter.setModel(transform);
        distorter.apply(input, output);
    }

    public static <T extends ImageSingleBand> void distortSingle(T input, T output, PixelTransform_F32 transform, ImageBorder<T> border, InterpolatePixel<T> interp) {
        Class<?> inputType = input.getClass();
        ImageDistort<T> distorter = FactoryDistort.distort(interp, border, inputType);
        distorter.setModel(transform);
        distorter.apply(input, output);
    }

    public static <T extends ImageSingleBand, M extends MultiSpectral<T>> void distortMS(M input, M output, PixelTransform_F32 transform, boolean skipOutsidePixels, TypeInterpolate interpType) {
        Class<T> bandType = input.getType();
        InterpolatePixel<T> interp = FactoryInterpolation.createPixel(0.0, 255.0, interpType, bandType);
        ImageBorder<T> border = skipOutsidePixels ? null : FactoryImageBorder.value(bandType, 0.0);
        ImageDistort<T> distorter = FactoryDistort.distort(interp, border, bandType);
        distorter.setModel(transform);
        DistortImageOps.distortMS(input, output, distorter);
    }

    public static <T extends ImageSingleBand> ImageDistort<T> createImageDistort(PointTransform_F32 transform, TypeInterpolate interpType, Class<T> imageType) {
        InterpolatePixel<T> interp = FactoryInterpolation.createPixel(0.0, 255.0, interpType, imageType);
        ImageDistort<T> distorter = FactoryDistort.distortCached(interp, FactoryImageBorder.value(imageType, 0.0), imageType);
        distorter.setModel(new PointToPixelTransform_F32(transform));
        return distorter;
    }

    public static <T extends ImageBase> void scale(T input, T output, TypeInterpolate interpType) {
        PixelTransformAffine_F32 model = DistortSupport.transformScale(output, input);
        if (input instanceof ImageSingleBand) {
            DistortImageOps.distortSingle((ImageSingleBand)input, (ImageSingleBand)output, (PixelTransform_F32)model, false, interpType);
        } else if (input instanceof MultiSpectral) {
            DistortImageOps.distortMS((MultiSpectral)input, (MultiSpectral)output, model, false, interpType);
        }
    }

    public static <T extends ImageBase> void rotate(T input, T output, TypeInterpolate interpType, float angleInputToOutput) {
        float offX = 0.0f;
        float offY = 0.0f;
        PixelTransformAffine_F32 model = DistortSupport.transformRotate(input.width / 2, input.height / 2, (float)(output.width / 2) - offX, (float)(output.height / 2) - offY, angleInputToOutput);
        if (input instanceof ImageSingleBand) {
            DistortImageOps.distortSingle((ImageSingleBand)input, (ImageSingleBand)output, (PixelTransform_F32)model, false, interpType);
        } else if (input instanceof MultiSpectral) {
            DistortImageOps.distortMS((MultiSpectral)input, (MultiSpectral)output, model, false, interpType);
        }
    }

    public static <T extends ImageSingleBand> void distortMS(MultiSpectral<T> input, MultiSpectral<T> output, ImageDistort<T> distortion) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            distortion.apply(input.getBand(band), output.getBand(band));
        }
    }

    public static Rectangle2D_I32 boundBox(int srcWidth, int srcHeight, int dstWidth, int dstHeight, PixelTransform_F32 transform) {
        Rectangle2D_I32 ret = DistortImageOps.boundBox(srcWidth, srcHeight, transform);
        int x0 = ret.tl_x;
        int y0 = ret.tl_y;
        int x1 = ret.tl_x + ret.width;
        int y1 = ret.tl_y + ret.height;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > dstWidth) {
            x1 = dstWidth;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > dstHeight) {
            y1 = dstHeight;
        }
        return new Rectangle2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static Rectangle2D_I32 boundBox(int srcWidth, int srcHeight, PixelTransform_F32 transform) {
        int y1;
        int x1;
        transform.compute(0, 0);
        int x0 = x1 = (int)transform.distX;
        int y0 = y1 = (int)transform.distY;
        for (int i = 1; i < 4; ++i) {
            if (i == 1) {
                transform.compute(srcWidth, 0);
            } else if (i == 2) {
                transform.compute(0, srcHeight);
            } else if (i == 3) {
                transform.compute(srcWidth - 1, srcHeight);
            }
            if (transform.distX < (float)x0) {
                x0 = (int)transform.distX;
            } else if (transform.distX > (float)x1) {
                x1 = (int)transform.distX;
            }
            if (transform.distY < (float)y0) {
                y0 = (int)transform.distY;
                continue;
            }
            if (!(transform.distY > (float)y1)) continue;
            y1 = (int)transform.distY;
        }
        return new Rectangle2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static Rectangle2D_F32 boundBox_F32(int srcWidth, int srcHeight, PixelTransform_F32 transform) {
        ImageRectangle_F32 r = new ImageRectangle_F32();
        r.y0 = Float.MAX_VALUE;
        r.x0 = Float.MAX_VALUE;
        r.y1 = -3.4028235E38f;
        r.x1 = -3.4028235E38f;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            DistortImageOps.updateBoundBox(transform, r);
            transform.compute(srcWidth, y);
            DistortImageOps.updateBoundBox(transform, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            DistortImageOps.updateBoundBox(transform, r);
            transform.compute(x, srcHeight);
            DistortImageOps.updateBoundBox(transform, r);
        }
        return new Rectangle2D_F32(r.x0, r.y0, r.x1 - r.x0, r.y1 - r.y0);
    }

    private static void updateBoundBox(PixelTransform_F32 transform, ImageRectangle_F32 r) {
        if (transform.distX < r.x0) {
            r.x0 = transform.distX;
        } else if (transform.distX > r.x1) {
            r.x1 = transform.distX;
        }
        if (transform.distY < r.y0) {
            r.y0 = transform.distY;
        } else if (transform.distY > r.y1) {
            r.y1 = transform.distY;
        }
    }
}

