/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.struct.FastQueue;
import boofcv.struct.GrowQueue_I32;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.feature.TupleDesc_F64;

public class AssociateSurfBasic {
    AssociateDescription<TupleDesc_F64> assoc;
    FastQueue<Helper> srcPositive = new FastQueue<Helper>(10, Helper.class, true);
    FastQueue<Helper> srcNegative = new FastQueue<Helper>(10, Helper.class, true);
    FastQueue<Helper> dstPositive = new FastQueue<Helper>(10, Helper.class, true);
    FastQueue<Helper> dstNegative = new FastQueue<Helper>(10, Helper.class, true);
    FastQueue<AssociatedIndex> matches = new FastQueue<AssociatedIndex>(10, AssociatedIndex.class, true);
    GrowQueue_I32 unassociatedSrc = new GrowQueue_I32();

    public AssociateSurfBasic(AssociateDescription<TupleDesc_F64> assoc) {
        this.assoc = assoc;
    }

    public void setSrc(FastQueue<SurfFeature> src) {
        this.sort(src, this.srcPositive, this.srcNegative);
    }

    public void setDst(FastQueue<SurfFeature> dst) {
        this.sort(dst, this.dstPositive, this.dstNegative);
    }

    public void swapLists() {
        FastQueue<Helper> tmp = this.srcPositive;
        this.srcPositive = this.dstPositive;
        this.dstPositive = tmp;
        tmp = this.srcNegative;
        this.srcNegative = this.dstNegative;
        this.dstNegative = tmp;
    }

    public void associate() {
        int i;
        this.matches.reset();
        this.unassociatedSrc.reset();
        this.assoc.setSource(this.srcPositive);
        this.assoc.setDestination(this.dstPositive);
        this.assoc.associate();
        FastQueue<AssociatedIndex> m = this.assoc.getMatches();
        for (int i2 = 0; i2 < m.size; ++i2) {
            AssociatedIndex a = ((AssociatedIndex[])m.data)[i2];
            int globalSrcIndex = ((Helper[])this.srcPositive.data)[a.src].index;
            int globalDstIndex = ((Helper[])this.dstPositive.data)[a.dst].index;
            this.matches.grow().setAssociation(globalSrcIndex, globalDstIndex, a.fitScore);
        }
        GrowQueue_I32 un = this.assoc.getUnassociatedSource();
        for (i = 0; i < un.size; ++i) {
            this.unassociatedSrc.add(((Helper[])this.srcPositive.data)[un.get((int)i)].index);
        }
        this.assoc.setSource(this.srcNegative);
        this.assoc.setDestination(this.dstNegative);
        this.assoc.associate();
        m = this.assoc.getMatches();
        for (i = 0; i < m.size; ++i) {
            AssociatedIndex a = ((AssociatedIndex[])m.data)[i];
            int globalSrcIndex = ((Helper[])this.srcNegative.data)[a.src].index;
            int globalDstIndex = ((Helper[])this.dstNegative.data)[a.dst].index;
            this.matches.grow().setAssociation(globalSrcIndex, globalDstIndex, a.fitScore);
        }
        un = this.assoc.getUnassociatedSource();
        for (i = 0; i < un.size; ++i) {
            this.unassociatedSrc.add(((Helper[])this.srcNegative.data)[un.get((int)i)].index);
        }
    }

    public FastQueue<AssociatedIndex> getMatches() {
        return this.matches;
    }

    private void sort(FastQueue<SurfFeature> input, FastQueue<Helper> pos, FastQueue<Helper> neg) {
        pos.reset();
        neg.reset();
        for (int i = 0; i < input.size; ++i) {
            SurfFeature f = input.get(i);
            if (f.laplacianPositive) {
                pos.grow().wrap(f, i);
                continue;
            }
            neg.grow().wrap(f, i);
        }
    }

    public int totalDestination() {
        return this.dstNegative.size + this.dstPositive.size;
    }

    public GrowQueue_I32 getUnassociatedSrc() {
        return this.unassociatedSrc;
    }

    public AssociateDescription<TupleDesc_F64> getAssoc() {
        return this.assoc;
    }

    public static class Helper
    extends TupleDesc_F64 {
        public int index;

        public void wrap(TupleDesc_F64 a, int index) {
            this.index = index;
            this.value = a.value;
        }
    }
}

