/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.quadblob;

import boofcv.alg.feature.detect.quadblob.FindQuadCorners;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DetectQuadBlobsBinary {
    FindQuadCorners cornerFinder = new FindQuadCorners();
    private int minContourSize;
    private double polySideRatio;
    private int minimumBlobCount;
    LinearContourLabelChang2004 contourAlg = new LinearContourLabelChang2004(8);
    ImageSInt32 labeledBlobs = new ImageSInt32(1, 1);
    int numLabels;
    List<Contour> contours = new ArrayList<Contour>();
    List<QuadBlob> squares;
    List<QuadBlob> squaresBad;
    String message;

    public DetectQuadBlobsBinary(int minContourSize, double polySideRatio, int minimumBlobCount) {
        this.minContourSize = minContourSize;
        this.polySideRatio = polySideRatio;
        this.minimumBlobCount = minimumBlobCount;
    }

    public void setMinContourSize(int minContourSize) {
        this.minContourSize = minContourSize;
    }

    public boolean process(ImageUInt8 binary) {
        this.squaresBad = new ArrayList<QuadBlob>();
        this.labeledBlobs.reshape(binary.width, binary.height);
        this.contourAlg.process(binary, this.labeledBlobs);
        this.contours.clear();
        this.contours.addAll(this.contourAlg.getContours().toList());
        this.numLabels = this.contours.size();
        if (this.contours.size() < this.minimumBlobCount) {
            return this.fail("Not enough blobs detected");
        }
        this.removeBlobsHolesAndTooSmall();
        this.filterTouchEdge();
        this.squares = new ArrayList<QuadBlob>();
        for (Contour c : this.contours) {
            List<Point2D_I32> corners = this.cornerFinder.process(c.external);
            if (corners.size() != 4) continue;
            this.squares.add(new QuadBlob(c.external, corners));
        }
        this.filterNotPolygon(this.squares);
        if (this.squares.size() < this.minimumBlobCount) {
            return this.fail("Too few valid squares");
        }
        return true;
    }

    private void removeBlobsHolesAndTooSmall() {
        int i = 0;
        while (i < this.contours.size()) {
            Contour c = this.contours.get(i);
            if (c.internal.size() > 0) {
                this.contours.remove(i);
                continue;
            }
            if (c.external.size() < 10) {
                this.contours.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void filterTouchEdge() {
        int w = this.labeledBlobs.width - 1;
        int h = this.labeledBlobs.height - 1;
        int i = 0;
        while (i < this.contours.size()) {
            Contour c = this.contours.get(i);
            boolean touching = false;
            for (Point2D_I32 p : c.external) {
                if (p.x != 0 && p.y != 0 && p.x != w && p.y != h) continue;
                touching = true;
                break;
            }
            if (touching) {
                this.contours.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void filterNotPolygon(List<QuadBlob> squares) {
        Iterator<QuadBlob> iter = squares.iterator();
        double[] d = new double[4];
        while (iter.hasNext()) {
            QuadBlob blob = iter.next();
            List<Point2D_I32> corners = blob.corners;
            Point2D_I32 p1 = corners.get(0);
            Point2D_I32 p2 = corners.get(1);
            Point2D_I32 p3 = corners.get(2);
            Point2D_I32 p4 = corners.get(3);
            d[0] = p1.distance(p2);
            d[1] = p2.distance(p3);
            d[2] = p3.distance(p4);
            d[3] = p4.distance(p1);
            double max = -1.0;
            double min = Double.MAX_VALUE;
            for (double v : d) {
                if (v > max) {
                    max = v;
                }
                if (!(v < min)) continue;
                min = v;
            }
            if (!(min / max < this.polySideRatio)) continue;
            this.squaresBad.add(blob);
            iter.remove();
        }
    }

    private boolean fail(String message) {
        this.message = message;
        return false;
    }

    public List<QuadBlob> getDetected() {
        return this.squares;
    }

    public List<QuadBlob> getInvalid() {
        return this.squaresBad;
    }

    public String getMessage() {
        return this.message;
    }

    public ImageSInt32 getLabeledImage() {
        return this.labeledBlobs;
    }

    public int getNumLabels() {
        return this.numLabels;
    }
}

