/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.quadblob;

import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import georegression.geometry.UtilPoint2D_I32;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.sorting.QuickSort_F64;

public class FindQuadCorners {
    int N;
    double[] acuteAngles = new double[1];

    public List<Point2D_I32> process(List<Point2D_I32> contour) {
        Point2D_I32 center = FindQuadCorners.findAverage(contour);
        FindQuadCorners.sortByAngleCCW(center, contour);
        this.N = contour.size();
        int radiusLarge = this.N / 10;
        if (radiusLarge < 2) {
            radiusLarge = 2;
        }
        if (this.acuteAngles.length < this.N) {
            this.acuteAngles = new double[this.N];
        }
        this.computeResponse(contour, radiusLarge, this.acuteAngles);
        int minIndex = -1;
        double minValue = Double.MAX_VALUE;
        ArrayList<Point2D_I32> candidates = new ArrayList<Point2D_I32>();
        for (int i = 0; i < this.N; ++i) {
            int indexBefore = UtilCalibrationGrid.incrementCircle(i, -1, this.N);
            int indexAfter = UtilCalibrationGrid.incrementCircle(i, 1, this.N);
            double r = this.acuteAngles[i];
            if (!(r <= this.acuteAngles[indexBefore]) || !(r <= this.acuteAngles[indexAfter])) continue;
            candidates.add(contour.get(i));
            if (!(r < minValue)) continue;
            minValue = r;
            minIndex = candidates.size() - 1;
        }
        if (candidates.size() < 4) {
            return candidates;
        }
        ArrayList<Point2D_I32> corners = new ArrayList<Point2D_I32>();
        corners.add((Point2D_I32)candidates.remove(minIndex));
        this.selectCorner(corners, candidates);
        this.selectCorner(corners, candidates);
        this.selectCorner(corners, candidates);
        FindQuadCorners.sortByAngleCCW(center, corners);
        return corners;
    }

    private void selectCorner(List<Point2D_I32> corners, List<Point2D_I32> candidates) {
        double maxDistance = -1.0;
        int maxIndex = -1;
        for (int i = 0; i < candidates.size(); ++i) {
            Point2D_I32 c = candidates.get(i);
            double d = 0.0;
            for (Point2D_I32 p : corners) {
                d += UtilPoint2D_I32.distance((Point2D_I32)c, (Point2D_I32)p);
            }
            if (!(d > maxDistance)) continue;
            maxDistance = d;
            maxIndex = i;
        }
        corners.add(candidates.remove(maxIndex));
    }

    protected static Point2D_I32 findAverage(List<Point2D_I32> contour) {
        int x = 0;
        int y = 0;
        for (Point2D_I32 p : contour) {
            x += p.x;
            y += p.y;
        }
        return new Point2D_I32(x /= contour.size(), y /= contour.size());
    }

    protected static void sortByAngleCCW(Point2D_I32 center, List<Point2D_I32> contour) {
        double[] angles = new double[contour.size()];
        int[] indexes = new int[angles.length];
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_I32 c = contour.get(i);
            int dx = c.x - center.x;
            int dy = c.y - center.y;
            angles[i] = Math.atan2(dy, dx);
        }
        QuickSort_F64 sort = new QuickSort_F64();
        sort.sort(angles, angles.length, indexes);
        ArrayList<Point2D_I32> sorted = new ArrayList<Point2D_I32>(contour.size());
        for (int i = 0; i < indexes.length; ++i) {
            sorted.add(contour.get(indexes[i]));
        }
        contour.clear();
        contour.addAll(sorted);
    }

    protected void computeResponse(List<Point2D_I32> contour, int radius, double[] response) {
        for (int i = 0; i < this.N; ++i) {
            int i0 = UtilCalibrationGrid.incrementCircle(i, -radius, this.N);
            int i1 = UtilCalibrationGrid.incrementCircle(i, radius, this.N);
            Point2D_I32 p0 = contour.get(i0);
            Point2D_I32 p1 = contour.get(i1);
            Point2D_I32 p = contour.get(i);
            double angle0 = Math.atan2(p0.y - p.y, p0.x - p.x);
            double angle1 = Math.atan2(p1.y - p.y, p1.x - p.x);
            response[i] = UtilAngle.dist((double)angle0, (double)angle1);
        }
    }
}

