/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.ContourTracer;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.FastQueue;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;

public class LinearContourLabelChang2004 {
    private ContourTracer tracer;
    private ImageUInt8 border = new ImageUInt8(1, 1);
    private FastQueue<Point2D_I32> storagePoints = new FastQueue<Point2D_I32>(Point2D_I32.class, true);
    private FastQueue<List<Point2D_I32>> storageLists = new FastQueue<ArrayList>(ArrayList.class, true);
    private FastQueue<Contour> contours = new FastQueue<Contour>(Contour.class, true);
    private int x;
    private int y;
    private int indexIn;
    private int indexOut;

    public LinearContourLabelChang2004(int rule) {
        this.tracer = new ContourTracer(rule);
    }

    public void process(ImageUInt8 binary, ImageSInt32 labeled) {
        if (this.border.width != binary.width + 2 || this.border.height != binary.height + 2) {
            this.border.reshape(binary.width + 2, binary.height + 2);
            ImageMiscOps.fillBorder(this.border, 0, 1);
        }
        ((ImageUInt8)this.border.subimage(1, 1, this.border.width - 1, this.border.height - 1)).setTo(binary);
        ImageMiscOps.fill(labeled, 0);
        binary = this.border;
        this.storagePoints.reset();
        this.storageLists.reset();
        this.contours.reset();
        this.tracer.setInputs(binary, labeled, this.storagePoints);
        this.y = 1;
        while (this.y < binary.height - 1) {
            this.indexIn = binary.startIndex + this.y * binary.stride + 1;
            this.indexOut = labeled.startIndex + (this.y - 1) * labeled.stride;
            this.x = 1;
            while (this.x < binary.width - 1) {
                byte bit = binary.data[this.indexIn];
                if (bit == 1) {
                    int label = labeled.data[this.indexOut];
                    boolean handled = false;
                    if (label == 0 && binary.data[this.indexIn - binary.stride] != 1) {
                        this.handleStep1();
                        handled = true;
                        label = this.contours.size;
                    }
                    if (binary.data[this.indexIn + binary.stride] == 0) {
                        this.handleStep2(labeled, label);
                        handled = true;
                    }
                    if (!handled) {
                        this.handleStep3(labeled);
                    }
                }
                ++this.x;
                ++this.indexIn;
                ++this.indexOut;
            }
            ++this.y;
        }
    }

    public FastQueue<Contour> getContours() {
        return this.contours;
    }

    private void handleStep1() {
        Contour c = this.contours.grow();
        c.reset();
        c.id = this.contours.size();
        this.tracer.trace(this.contours.size(), this.x, this.y, true, c.external);
    }

    private void handleStep2(ImageSInt32 labeled, int label) {
        if (label == 0) {
            label = labeled.data[this.indexOut - 1];
        }
        Contour c = this.contours.get(label - 1);
        List<Point2D_I32> inner = this.storageLists.grow();
        inner.clear();
        c.internal.add(inner);
        this.tracer.trace(label, this.x, this.y, false, inner);
    }

    private void handleStep3(ImageSInt32 labeled) {
        if (labeled.data[this.indexOut] == 0) {
            labeled.data[this.indexOut] = labeled.data[this.indexOut - 1];
        }
    }
}

