/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class ThresholdImageOps {
    public static ImageUInt8 threshold(ImageFloat32 input, ImageUInt8 output, float threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] >= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageFloat64 input, ImageUInt8 output, double threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] >= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageUInt8 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFF) <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFF) >= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageSInt16 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] >= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageUInt16 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFFFF) <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = (input.data[indexIn] & 0xFFFF) >= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }

    public static ImageUInt8 threshold(ImageSInt32 input, ImageUInt8 output, int threshold, boolean down) {
        output = InputSanityCheck.checkDeclare(input, output, ImageUInt8.class);
        if (down) {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] <= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int end = indexIn + input.width;
                while (indexIn < end) {
                    output.data[indexOut] = input.data[indexIn] >= threshold ? (byte)1 : 0;
                    ++indexIn;
                    ++indexOut;
                }
            }
        }
        return output;
    }
}

