/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ConvolveImageStandardSparse {
    public static float convolve(Kernel1D_F32 horizontal, Kernel1D_F32 vertical, ImageFloat32 input, int c_x, int c_y, float[] storage) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        for (int i = 0; i < width; ++i) {
            int indexImg = input.startIndex + (i + c_y - radius) * input.stride + c_x - radius;
            float total = 0.0f;
            int j = 0;
            while (j < width) {
                total += input.data[indexImg] * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total;
        }
        float total = 0.0f;
        for (int i = 0; i < width; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageUInt8 input, int c_x, int c_y, int[] storage) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        for (int i = 0; i < width; ++i) {
            int indexImg = input.startIndex + (i + c_y - radius) * input.stride + c_x - radius;
            int total = 0;
            int j = 0;
            while (j < width) {
                total += (input.data[indexImg] & 0xFF) * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total;
        }
        int total = 0;
        for (int i = 0; i < width; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageUInt8 input, int c_x, int c_y, int[] storage, int divisorHorizontal, int divisorVertical) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        for (int i = 0; i < width; ++i) {
            int indexImg = input.startIndex + (i + c_y - radius) * input.stride + c_x - radius;
            int total = 0;
            int j = 0;
            while (j < width) {
                total += (input.data[indexImg] & 0xFF) * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total / divisorHorizontal;
        }
        int total = 0;
        for (int i = 0; i < width; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total / divisorVertical;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageSInt16 input, int c_x, int c_y, int[] storage) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        for (int i = 0; i < width; ++i) {
            int indexImg = input.startIndex + (i + c_y - radius) * input.stride + c_x - radius;
            int total = 0;
            int j = 0;
            while (j < width) {
                total += input.data[indexImg] * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total;
        }
        int total = 0;
        for (int i = 0; i < width; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageSInt16 input, int c_x, int c_y, int[] storage, int divisorHorizontal, int divisorVertical) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        for (int i = 0; i < width; ++i) {
            int indexImg = input.startIndex + (i + c_y - radius) * input.stride + c_x - radius;
            int total = 0;
            int j = 0;
            while (j < width) {
                total += input.data[indexImg] * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total / divisorHorizontal;
        }
        int total = 0;
        for (int i = 0; i < width; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total / divisorVertical;
    }
}

