/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;

public class ImplConvolveBox {
    public static void horizontal(ImageUInt8 input, ImageInt16 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = (short)(total += input.data[indexIn] & 0xFF);
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageUInt8 input, ImageInt16 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut] = (short)total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                int total = output.data[indexOut - output.stride] - (input.data[indexIn - backStep] & 0xFF);
                output.data[indexOut] = (short)(total += input.data[indexIn] & 0xFF);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageUInt8 input, ImageSInt32 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = total += input.data[indexIn] & 0xFF;
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageUInt8 input, ImageSInt32 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut] = total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                int total = output.data[indexOut - output.stride] - (input.data[indexIn - backStep] & 0xFF);
                output.data[indexOut] = total += input.data[indexIn] & 0xFF;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageSInt16 input, ImageInt16 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = (short)total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (short)(total += input.data[indexIn]);
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageSInt16 input, ImageInt16 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            output.data[indexOut] = (short)total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                int total = output.data[indexOut - output.stride] - input.data[indexIn - backStep];
                output.data[indexOut] = (short)(total += input.data[indexIn]);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageFloat32 input, ImageFloat32 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            float total = 0.0f;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = total += input.data[indexIn];
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageFloat32 input, ImageFloat32 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            float total = 0.0f;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            output.data[indexOut] = total;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                float total = output.data[indexOut - output.stride] - input.data[indexIn - backStep];
                output.data[indexOut] = total += input.data[indexIn];
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }
}

