/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class DerivativeHelperFunctions {
    public static void processBorderHorizontal(ImageUInt8 orig, ImageSInt16 deriv, Kernel1D_I32 kernel, int border, ImageBorder_I32 borderType) {
        borderType.setImage(orig);
        ConvolveJustBorder_General.horizontal(kernel, borderType, deriv, border);
        ImageUInt8 origSub = (ImageUInt8)orig.subimage(0, 0, orig.width, 2);
        ImageSInt16 derivSub = (ImageSInt16)deriv.subimage(0, 0, orig.width, 2);
        ConvolveImageNoBorder.horizontal(kernel, origSub, (ImageInt16)derivSub, true);
        origSub = (ImageUInt8)orig.subimage(0, orig.height - 2, orig.width, orig.height);
        derivSub = (ImageSInt16)deriv.subimage(0, orig.height - 2, orig.width, orig.height);
        ConvolveImageNoBorder.horizontal(kernel, origSub, (ImageInt16)derivSub, true);
    }

    public static void processBorderHorizontal(ImageSInt16 orig, ImageSInt16 deriv, Kernel1D_I32 kernel, int border, ImageBorder_I32 borderType) {
        borderType.setImage(orig);
        ConvolveJustBorder_General.horizontal(kernel, borderType, deriv, border);
        ImageSInt16 origSub = (ImageSInt16)orig.subimage(0, 0, orig.width, 2);
        ImageSInt16 derivSub = (ImageSInt16)deriv.subimage(0, 0, orig.width, 2);
        ConvolveImageNoBorder.horizontal(kernel, origSub, (ImageInt16)derivSub, true);
        origSub = (ImageSInt16)orig.subimage(0, orig.height - 2, orig.width, orig.height);
        derivSub = (ImageSInt16)deriv.subimage(0, orig.height - 2, orig.width, orig.height);
        ConvolveImageNoBorder.horizontal(kernel, origSub, (ImageInt16)derivSub, true);
    }

    public static void processBorderVertical(ImageUInt8 orig, ImageSInt16 deriv, Kernel1D_I32 kernel, int border, ImageBorder_I32 borderType) {
        borderType.setImage(orig);
        ConvolveJustBorder_General.vertical(kernel, borderType, deriv, border);
        ImageUInt8 origSub = (ImageUInt8)orig.subimage(0, 0, 2, orig.height);
        ImageSInt16 derivSub = (ImageSInt16)deriv.subimage(0, 0, 2, orig.height);
        ConvolveImageNoBorder.vertical(kernel, origSub, (ImageInt16)derivSub, true);
        origSub = (ImageUInt8)orig.subimage(orig.width - 2, 0, orig.width, orig.height);
        derivSub = (ImageSInt16)deriv.subimage(orig.width - 2, 0, orig.width, orig.height);
        ConvolveImageNoBorder.vertical(kernel, origSub, (ImageInt16)derivSub, true);
    }

    public static void processBorderVertical(ImageSInt16 orig, ImageSInt16 deriv, Kernel1D_I32 kernel, int border, ImageBorder_I32 borderType) {
        borderType.setImage(orig);
        ConvolveJustBorder_General.vertical(kernel, borderType, deriv, border);
        ImageSInt16 origSub = (ImageSInt16)orig.subimage(0, 0, 2, orig.height);
        ImageSInt16 derivSub = (ImageSInt16)deriv.subimage(0, 0, 2, orig.height);
        ConvolveImageNoBorder.vertical(kernel, origSub, (ImageInt16)derivSub, true);
        origSub = (ImageSInt16)orig.subimage(orig.width - 2, 0, orig.width, orig.height);
        derivSub = (ImageSInt16)deriv.subimage(orig.width - 2, 0, orig.width, orig.height);
        ConvolveImageNoBorder.vertical(kernel, origSub, (ImageInt16)derivSub, true);
    }

    public static void processBorderHorizontal(ImageFloat32 orig, ImageFloat32 deriv, Kernel1D_F32 kernel, int border, ImageBorder_F32 borderType) {
        borderType.setImage(orig);
        ConvolveJustBorder_General.horizontal(kernel, borderType, deriv, border);
        ImageFloat32 origSub = (ImageFloat32)orig.subimage(0, 0, orig.width, 2);
        ImageFloat32 derivSub = (ImageFloat32)deriv.subimage(0, 0, orig.width, 2);
        ConvolveImageNoBorder.horizontal(kernel, origSub, derivSub, true);
        origSub = (ImageFloat32)orig.subimage(0, orig.height - 2, orig.width, orig.height);
        derivSub = (ImageFloat32)deriv.subimage(0, orig.height - 2, orig.width, orig.height);
        ConvolveImageNoBorder.horizontal(kernel, origSub, derivSub, true);
    }

    public static void processBorderVertical(ImageFloat32 orig, ImageFloat32 deriv, Kernel1D_F32 kernel, int border, ImageBorder_F32 borderType) {
        borderType.setImage(orig);
        ConvolveJustBorder_General.vertical(kernel, borderType, deriv, border);
        ImageFloat32 origSub = (ImageFloat32)orig.subimage(0, 0, 2, orig.height);
        ImageFloat32 derivSub = (ImageFloat32)deriv.subimage(0, 0, 2, orig.height);
        ConvolveImageNoBorder.vertical(kernel, origSub, derivSub, true);
        origSub = (ImageFloat32)orig.subimage(orig.width - 2, 0, orig.width, orig.height);
        derivSub = (ImageFloat32)deriv.subimage(orig.width - 2, 0, orig.width, orig.height);
        ConvolveImageNoBorder.vertical(kernel, origSub, derivSub, true);
    }
}

