/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class DecomposeEssential {
    private SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);
    DenseMatrix64F U;
    DenseMatrix64F S;
    DenseMatrix64F V;
    List<Se3_F64> solutions = new ArrayList<Se3_F64>();
    DenseMatrix64F E_copy = new DenseMatrix64F(3, 3);
    DenseMatrix64F temp = new DenseMatrix64F(3, 3);
    DenseMatrix64F temp2 = new DenseMatrix64F(3, 3);
    DenseMatrix64F Rz = new DenseMatrix64F(3, 3);

    public DecomposeEssential() {
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.Rz.set(0, 1, 1.0);
        this.Rz.set(1, 0, -1.0);
        this.Rz.set(2, 2, 1.0);
    }

    public void decompose(DenseMatrix64F E) {
        if (this.svd.inputModified()) {
            this.E_copy.set((D1Matrix64F)E);
            E = this.E_copy;
        }
        if (!this.svd.decompose((Matrix64F)E)) {
            throw new RuntimeException("Svd some how failed");
        }
        this.U = (DenseMatrix64F)this.svd.getU((Matrix64F)this.U, false);
        this.V = (DenseMatrix64F)this.svd.getV((Matrix64F)this.V, false);
        this.S = (DenseMatrix64F)this.svd.getW((Matrix64F)this.S);
        SingularOps.descendingOrder((DenseMatrix64F)this.U, (boolean)false, (DenseMatrix64F)this.S, (DenseMatrix64F)this.V, (boolean)false);
        this.decompose(this.U, this.S, this.V);
    }

    public void decompose(DenseMatrix64F U, DenseMatrix64F S, DenseMatrix64F V) {
        if (CommonOps.det((DenseMatrix64F)U) < 0.0) {
            CommonOps.scale((double)-1.0, (D1Matrix64F)U);
            CommonOps.scale((double)-1.0, (D1Matrix64F)S);
        }
        if (CommonOps.det((DenseMatrix64F)V) < 0.0) {
            CommonOps.scale((double)-1.0, (D1Matrix64F)V);
            CommonOps.scale((double)-1.0, (D1Matrix64F)S);
        }
        this.extractTransform(U, V, S, this.solutions.get(0), true, true);
        this.extractTransform(U, V, S, this.solutions.get(1), true, false);
        this.extractTransform(U, V, S, this.solutions.get(2), false, false);
        this.extractTransform(U, V, S, this.solutions.get(3), false, true);
    }

    public List<Se3_F64> getSolutions() {
        return this.solutions;
    }

    private void extractTransform(DenseMatrix64F U, DenseMatrix64F V, DenseMatrix64F S, Se3_F64 se, boolean optionA, boolean optionB) {
        DenseMatrix64F R = se.getR();
        Vector3D_F64 T = se.getT();
        if (optionA) {
            CommonOps.mult((RowD1Matrix64F)U, (RowD1Matrix64F)this.Rz, (RowD1Matrix64F)this.temp);
        } else {
            CommonOps.multTransB((RowD1Matrix64F)U, (RowD1Matrix64F)this.Rz, (RowD1Matrix64F)this.temp);
        }
        CommonOps.multTransB((RowD1Matrix64F)this.temp, (RowD1Matrix64F)V, (RowD1Matrix64F)R);
        if (optionB) {
            CommonOps.multTransB((RowD1Matrix64F)U, (RowD1Matrix64F)this.Rz, (RowD1Matrix64F)this.temp);
        } else {
            CommonOps.mult((RowD1Matrix64F)U, (RowD1Matrix64F)this.Rz, (RowD1Matrix64F)this.temp);
        }
        CommonOps.mult((RowD1Matrix64F)this.temp, (RowD1Matrix64F)S, (RowD1Matrix64F)this.temp2);
        CommonOps.multTransB((RowD1Matrix64F)this.temp2, (RowD1Matrix64F)U, (RowD1Matrix64F)this.temp);
        T.x = this.temp.get(2, 1);
        T.y = this.temp.get(0, 2);
        T.z = this.temp.get(1, 0);
    }
}

