/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.Zhang99Parameters;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DenseMatrix64F;

public class Zhang99OptimizationFunction
implements FunctionNtoM {
    private int N;
    private int M;
    private List<Point3D_F64> grid = new ArrayList<Point3D_F64>();
    private Zhang99Parameters param;
    private Se3_F64 se = new Se3_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2D_F64 calibratedPt = new Point2D_F64();
    private List<List<Point2D_F64>> observations;

    public Zhang99OptimizationFunction(Zhang99Parameters param, List<Point2D_F64> grid, List<List<Point2D_F64>> observations) {
        if (param.views.length != observations.size()) {
            throw new IllegalArgumentException("For each view there should be one observation");
        }
        this.param = param;
        this.observations = observations;
        for (Point2D_F64 p : grid) {
            this.grid.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        this.N = param.size();
        this.M = observations.size() * grid.size() * 2;
    }

    public int getN() {
        return this.N;
    }

    public int getM() {
        return this.M;
    }

    public void process(double[] input, double[] output) {
        this.param.setFromParam(input);
        this.process(this.param, output);
    }

    public void process(Zhang99Parameters param, double[] residuals) {
        int index = 0;
        for (int indexView = 0; indexView < param.views.length; ++indexView) {
            Zhang99Parameters.View v = param.views[indexView];
            RotationMatrixGenerator.rodriguesToMatrix((Rodrigues)v.rotation, (DenseMatrix64F)this.se.getR());
            this.se.T = v.T;
            List<Point2D_F64> obs = this.observations.get(indexView);
            for (int i = 0; i < this.grid.size(); ++i) {
                SePointOps_F64.transform((Se3_F64)this.se, (Point3D_F64)this.grid.get(i), (Point3D_F64)this.cameraPt);
                this.calibratedPt.x = this.cameraPt.x / this.cameraPt.z;
                this.calibratedPt.y = this.cameraPt.y / this.cameraPt.z;
                CalibrationPlanarGridZhang99.applyDistortion(this.calibratedPt, param.distortion);
                double x = param.a * this.calibratedPt.x + param.c * this.calibratedPt.y + param.x0;
                double y = param.b * this.calibratedPt.y + param.y0;
                Point2D_F64 p = obs.get(i);
                residuals[index++] = x - p.x;
                residuals[index++] = y - p.y;
            }
        }
    }
}

