/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.struct.calib.IntrinsicParameters;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.so.Rodrigues;

public class Zhang99Parameters {
    public double a;
    public double b;
    public double c;
    public double x0;
    public double y0;
    public double[] distortion;
    public boolean assumeZeroSkew;
    public View[] views;

    public Zhang99Parameters(boolean assumeZeroSkew, int numDistort, int numViews) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.distortion = new double[numDistort];
        this.setNumberOfViews(numViews);
    }

    public Zhang99Parameters(boolean assumeZeroSkew, int numDistort) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.distortion = new double[numDistort];
    }

    public Zhang99Parameters() {
    }

    public void setNumberOfViews(int numViews) {
        this.views = new View[numViews];
        for (int i = 0; i < numViews; ++i) {
            this.views[i] = new View();
        }
    }

    public Zhang99Parameters createNew() {
        return new Zhang99Parameters(this.assumeZeroSkew, this.distortion.length, this.views.length);
    }

    public Zhang99Parameters copy() {
        int i;
        Zhang99Parameters ret = this.createNew();
        ret.a = this.a;
        ret.b = this.b;
        ret.c = this.c;
        ret.x0 = this.x0;
        ret.y0 = this.y0;
        for (i = 0; i < this.distortion.length; ++i) {
            ret.distortion[i] = this.distortion[i];
        }
        for (i = 0; i < this.views.length; ++i) {
            View a = this.views[i];
            View b = ret.views[i];
            b.rotation.unitAxisRotation.set(a.rotation.unitAxisRotation);
            b.rotation.theta = a.rotation.theta;
            b.T.set(a.T);
        }
        return ret;
    }

    public int size() {
        if (this.assumeZeroSkew) {
            return 4 + this.distortion.length + 6 * this.views.length;
        }
        return 5 + this.distortion.length + 6 * this.views.length;
    }

    public void setFromParam(double[] param) {
        int index = 0;
        this.a = param[index++];
        this.b = param[index++];
        if (!this.assumeZeroSkew) {
            this.c = param[index++];
        }
        this.x0 = param[index++];
        this.y0 = param[index++];
        for (int i = 0; i < this.distortion.length; ++i) {
            this.distortion[i] = param[index++];
        }
        for (View v : this.views) {
            v.rotation.setParamVector(param[index++], param[index++], param[index++]);
            v.T.x = param[index++];
            v.T.y = param[index++];
            v.T.z = param[index++];
        }
    }

    public void convertToParam(double[] param) {
        int index = 0;
        param[index++] = this.a;
        param[index++] = this.b;
        if (!this.assumeZeroSkew) {
            param[index++] = this.c;
        }
        param[index++] = this.x0;
        param[index++] = this.y0;
        for (int i = 0; i < this.distortion.length; ++i) {
            param[index++] = this.distortion[i];
        }
        for (View v : this.views) {
            param[index++] = v.rotation.unitAxisRotation.x * v.rotation.theta;
            param[index++] = v.rotation.unitAxisRotation.y * v.rotation.theta;
            param[index++] = v.rotation.unitAxisRotation.z * v.rotation.theta;
            param[index++] = v.T.x;
            param[index++] = v.T.y;
            param[index++] = v.T.z;
        }
    }

    public IntrinsicParameters convertToIntrinsic() {
        IntrinsicParameters ret = new IntrinsicParameters();
        ret.fx = this.a;
        ret.fy = this.b;
        ret.skew = this.assumeZeroSkew ? 0.0 : this.c;
        ret.cx = this.x0;
        ret.cy = this.y0;
        ret.radial = new double[this.distortion.length];
        System.arraycopy(this.distortion, 0, ret.radial, 0, this.distortion.length);
        return ret;
    }

    public static class View {
        public Rodrigues rotation = new Rodrigues();
        public Vector3D_F64 T = new Vector3D_F64();
    }
}

