/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.MultiViewOps;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class ParamFundamentalEpipolar
implements ModelCodec<DenseMatrix64F> {
    int col0;
    int col1;
    int col2;
    int[] indexes = new int[6];

    public int getParamLength() {
        return 7;
    }

    public void encode(DenseMatrix64F F, double[] param) {
        this.selectColumns(F);
        double[] v = new double[]{F.get(0, this.col0), F.get(1, this.col0), F.get(2, this.col0), F.get(0, this.col1), F.get(1, this.col1), F.get(2, this.col1)};
        double divisor = this.selectDivisor(v, param);
        SimpleMatrix A = new SimpleMatrix(3, 2);
        SimpleMatrix y = new SimpleMatrix(3, 1);
        for (int i = 0; i < 3; ++i) {
            A.set(i, 0, v[i]);
            A.set(i, 1, v[i + 3]);
            y.set(i, 0, F.get(i, this.col2) / divisor);
        }
        SimpleMatrix x = (SimpleMatrix)A.solve((SimpleBase)y);
        param[5] = x.get(0);
        param[6] = x.get(1);
    }

    private double selectDivisor(double[] v, double[] param) {
        double maxValue = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(Math.abs(v[i]) > maxValue)) continue;
            maxValue = Math.abs(v[i]);
            maxIndex = i;
        }
        double divisor = v[maxIndex];
        int index = 0;
        for (int i = 0; i < v.length; ++i) {
            int n = i;
            v[n] = v[n] / divisor;
            if (i == maxIndex) continue;
            param[index] = v[i];
            int col = i < 3 ? this.col0 : this.col1;
            this.indexes[index++] = 3 * (i % 3) + col;
        }
        int col = maxIndex >= 3 ? this.col1 : this.col0;
        this.indexes[5] = 3 * (maxIndex % 3) + col;
        return divisor;
    }

    private void selectColumns(DenseMatrix64F F) {
        Point3D_F64 e1 = new Point3D_F64();
        Point3D_F64 e2 = new Point3D_F64();
        MultiViewOps.extractEpipoles(F, e1, e2);
        if (Math.abs(e2.z) <= UtilEjml.EPS) {
            this.col0 = 1;
            this.col1 = 2;
            this.col2 = 0;
        } else {
            this.col0 = 0;
            this.col1 = 1;
            this.col2 = 2;
        }
    }

    public void decode(double[] input, DenseMatrix64F F) {
        F.data[this.indexes[0]] = input[0];
        F.data[this.indexes[1]] = input[1];
        F.data[this.indexes[2]] = input[2];
        F.data[this.indexes[3]] = input[3];
        F.data[this.indexes[4]] = input[4];
        F.data[this.indexes[5]] = 1.0;
        double alpha = input[5];
        double beta = input[6];
        F.data[this.col2] = alpha * F.data[this.col0] + beta * F.data[this.col1];
        F.data[this.col2 + 3] = alpha * F.data[this.col0 + 3] + beta * F.data[this.col1 + 3];
        F.data[this.col2 + 6] = alpha * F.data[this.col0 + 6] + beta * F.data[this.col1 + 6];
    }
}

