/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.trifocal.EnforceTrifocalGeometry;
import boofcv.alg.geo.trifocal.TrifocalExtractEpipoles;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ejml.alg.dense.decomposition.svd.SafeSvd;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class TrifocalLinearPoint7 {
    protected TrifocalTensor solutionN = new TrifocalTensor();
    protected DenseMatrix64F N1 = new DenseMatrix64F(3, 3);
    protected DenseMatrix64F N2 = new DenseMatrix64F(3, 3);
    protected DenseMatrix64F N3 = new DenseMatrix64F(3, 3);
    protected DenseMatrix64F A = new DenseMatrix64F(7, 27);
    protected SingularValueDecomposition<DenseMatrix64F> svdNull;
    protected DenseMatrix64F vectorizedSolution = new DenseMatrix64F(27, 1);
    protected Point2D_F64 p1_norm = new Point2D_F64();
    protected Point2D_F64 p2_norm = new Point2D_F64();
    protected Point2D_F64 p3_norm = new Point2D_F64();
    protected EnforceTrifocalGeometry enforce = new EnforceTrifocalGeometry();
    protected TrifocalExtractEpipoles extractEpipoles = new TrifocalExtractEpipoles();
    protected Point3D_F64 e2 = new Point3D_F64();
    protected Point3D_F64 e3 = new Point3D_F64();

    public TrifocalLinearPoint7() {
        this.svdNull = DecompositionFactory.svd((int)24, (int)27, (boolean)false, (boolean)true, (boolean)false);
        this.svdNull = new SafeSvd(this.svdNull);
    }

    public boolean process(List<AssociatedTriple> observations, TrifocalTensor solution) {
        if (observations.size() < 7) {
            throw new IllegalArgumentException("At least 7 correspondences must be provided");
        }
        LowLevelMultiViewOps.computeNormalization(observations, this.N1, this.N2, this.N3);
        this.createLinearSystem(observations);
        this.solveLinearSystem();
        this.extractEpipoles.process(this.solutionN, this.e2, this.e3);
        this.enforce.process(this.e2, this.e3, this.A);
        this.enforce.extractSolution(this.solutionN);
        this.removeNormalization(solution);
        return true;
    }

    protected void createLinearSystem(List<AssociatedTriple> observations) {
        int N = observations.size();
        this.A.reshape(4 * N, 27);
        this.A.zero();
        int index1 = 0;
        for (int i = 0; i < N; ++i) {
            AssociatedTriple t = observations.get(i);
            LowLevelMultiViewOps.applyPixelNormalization(this.N1, t.p1, this.p1_norm);
            LowLevelMultiViewOps.applyPixelNormalization(this.N2, t.p2, this.p2_norm);
            LowLevelMultiViewOps.applyPixelNormalization(this.N3, t.p3, this.p3_norm);
            int index2 = index1 + 9;
            int index3 = index1 + 18;
            this.A.data[index1 + 8] = this.p1_norm.x * this.p2_norm.x * this.p3_norm.x;
            this.A.data[index1 + 2] = -this.p1_norm.x * this.p3_norm.x;
            this.A.data[index1 + 6] = -this.p1_norm.x * this.p2_norm.x;
            this.A.data[index1] = this.p1_norm.x;
            this.A.data[index2 + 8] = this.p1_norm.y * this.p2_norm.x * this.p3_norm.x;
            this.A.data[index2 + 2] = -this.p1_norm.y * this.p3_norm.x;
            this.A.data[index2 + 6] = -this.p1_norm.y * this.p2_norm.x;
            this.A.data[index2] = this.p1_norm.y;
            this.A.data[index3 + 8] = this.p2_norm.x * this.p3_norm.x;
            this.A.data[index3 + 2] = -this.p3_norm.x;
            this.A.data[index3 + 6] = -this.p2_norm.x;
            this.A.data[index3] = 1.0;
            index2 = (index1 += 27) + 9;
            index3 = index1 + 18;
            this.A.data[index1 + 8] = this.p1_norm.x * this.p2_norm.x * this.p3_norm.y;
            this.A.data[index1 + 2] = -this.p1_norm.x * this.p3_norm.y;
            this.A.data[index1 + 7] = -this.p1_norm.x * this.p2_norm.x;
            this.A.data[index1 + 1] = this.p1_norm.x;
            this.A.data[index2 + 8] = this.p1_norm.y * this.p2_norm.x * this.p3_norm.y;
            this.A.data[index2 + 2] = -this.p1_norm.y * this.p3_norm.y;
            this.A.data[index2 + 7] = -this.p1_norm.y * this.p2_norm.x;
            this.A.data[index2 + 1] = this.p1_norm.y;
            this.A.data[index3 + 8] = this.p2_norm.x * this.p3_norm.y;
            this.A.data[index3 + 2] = -this.p3_norm.y;
            this.A.data[index3 + 7] = -this.p2_norm.x;
            this.A.data[index3 + 1] = 1.0;
            index2 = (index1 += 27) + 9;
            index3 = index1 + 18;
            this.A.data[index1 + 8] = this.p1_norm.x * this.p2_norm.y * this.p3_norm.y;
            this.A.data[index1 + 5] = -this.p1_norm.x * this.p3_norm.y;
            this.A.data[index1 + 7] = -this.p1_norm.x * this.p2_norm.y;
            this.A.data[index1 + 4] = this.p1_norm.x;
            this.A.data[index2 + 8] = this.p1_norm.y * this.p2_norm.y * this.p3_norm.y;
            this.A.data[index2 + 5] = -this.p1_norm.y * this.p3_norm.y;
            this.A.data[index2 + 7] = -this.p1_norm.y * this.p2_norm.y;
            this.A.data[index2 + 4] = this.p1_norm.y;
            this.A.data[index3 + 8] = this.p2_norm.y * this.p3_norm.y;
            this.A.data[index3 + 5] = -this.p3_norm.y;
            this.A.data[index3 + 7] = -this.p2_norm.y;
            this.A.data[index3 + 4] = 1.0;
            index2 = (index1 += 27) + 9;
            index3 = index1 + 18;
            this.A.data[index1 + 8] = this.p1_norm.x * this.p2_norm.y * this.p3_norm.x;
            this.A.data[index1 + 5] = -this.p1_norm.x * this.p3_norm.x;
            this.A.data[index1 + 6] = -this.p1_norm.x * this.p2_norm.y;
            this.A.data[index1 + 3] = this.p1_norm.x;
            this.A.data[index2 + 8] = this.p1_norm.y * this.p2_norm.y * this.p3_norm.x;
            this.A.data[index2 + 5] = -this.p1_norm.y * this.p3_norm.x;
            this.A.data[index2 + 6] = -this.p1_norm.y * this.p2_norm.y;
            this.A.data[index2 + 3] = this.p1_norm.y;
            this.A.data[index3 + 8] = this.p2_norm.y * this.p3_norm.x;
            this.A.data[index3 + 5] = -this.p3_norm.x;
            this.A.data[index3 + 6] = -this.p2_norm.y;
            this.A.data[index3 + 3] = 1.0;
            index1 += 27;
        }
    }

    protected boolean solveLinearSystem() {
        if (!this.svdNull.decompose((Matrix64F)this.A)) {
            return false;
        }
        SingularOps.nullVector(this.svdNull, (boolean)true, (DenseMatrix64F)this.vectorizedSolution);
        this.solutionN.convertFrom(this.vectorizedSolution);
        return true;
    }

    protected void removeNormalization(TrifocalTensor solution) {
        DenseMatrix64F N2_inv = new DenseMatrix64F(3, 3);
        DenseMatrix64F N3_inv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)this.N2, (DenseMatrix64F)N2_inv);
        CommonOps.invert((DenseMatrix64F)this.N3, (DenseMatrix64F)N3_inv);
        for (int i = 0; i < 3; ++i) {
            DenseMatrix64F T = solution.getT(i);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double sum = 0.0;
                    for (int r = 0; r < 3; ++r) {
                        double n1 = this.N1.get(r, i);
                        DenseMatrix64F TN = this.solutionN.getT(r);
                        for (int s = 0; s < 3; ++s) {
                            double n2 = N2_inv.get(j, s);
                            for (int t = 0; t < 3; ++t) {
                                sum += n1 * n2 * N3_inv.get(k, t) * TN.get(s, t);
                            }
                        }
                    }
                    T.set(j, k, sum);
                }
            }
        }
    }
}

