/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.struct.image.ImageInterleavedInt8;
import java.util.Random;

public class ImageInterleavedTestingOps {
    public static void fill(ImageInterleavedInt8 img, byte ... value) {
        if (value.length != img.numBands) {
            throw new IllegalArgumentException("Unexpected number of bands");
        }
        int h = img.getHeight();
        int w = img.getWidth();
        byte[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index = img.getStartIndex() + y * img.getStride();
            for (int x = 0; x < w; ++x) {
                for (int k = 0; k < img.numBands; ++k) {
                    data[index++] = value[k];
                }
            }
        }
    }

    public static void randomize(ImageInterleavedInt8 img, Random rand) {
        int h = img.getHeight();
        int w = img.getWidth();
        byte[] data = img.data;
        int range = 255;
        for (int y = 0; y < h; ++y) {
            int index = img.getStartIndex() + y * img.getStride();
            for (int x = 0; x < w; ++x) {
                for (int k = 0; k < img.numBands; ++k) {
                    data[index++] = (byte)(rand.nextInt(range) + -128);
                }
            }
        }
    }
}

