/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homo.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homo.HomographyPointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceHomographyPixelSq
implements DistanceFromModel<Homography2D_F64, AssociatedPair> {
    Homography2D_F64 model;
    Point2D_F64 expected = new Point2D_F64();
    NormalizedToPixelError errorCam2 = new NormalizedToPixelError();

    public void setIntrinsic(double cam2_fx, double cam2_fy, double cam2_skew) {
        this.errorCam2.set(cam2_fx, cam2_fy, cam2_skew);
    }

    public void setModel(Homography2D_F64 model) {
        this.model = model;
    }

    public double computeDistance(AssociatedPair pt) {
        HomographyPointOps_F64.transform((Homography2D_F64)this.model, (Point2D_F64)pt.p1, (Point2D_F64)this.expected);
        return this.errorCam2.errorSq(this.expected, pt.p2);
    }

    public void computeDistance(List<AssociatedPair> points, double[] distance) {
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            HomographyPointOps_F64.transform((Homography2D_F64)this.model, (Point2D_F64)p.p1, (Point2D_F64)this.expected);
            distance[i] = this.errorCam2.errorSq(this.expected, p.p2);
        }
    }
}

