/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.struct.geo.Point2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;

public class DistanceTranGivenRotSq
implements DistanceFromModel<Vector3D_F64, Point2D3D> {
    Se3_F64 motion = new Se3_F64();
    Point3D_F64 localX = new Point3D_F64();

    public void setRotation(DenseMatrix64F R) {
        this.motion.getR().set((D1Matrix64F)R);
    }

    public void setModel(Vector3D_F64 translation) {
        this.motion.getT().set(translation);
    }

    public double computeDistance(Point2D3D pt) {
        Point3D_F64 X = pt.location;
        Point2D_F64 obs = pt.observation;
        SePointOps_F64.transform((Se3_F64)this.motion, (Point3D_F64)X, (Point3D_F64)this.localX);
        double dx = obs.x - this.localX.x / this.localX.z;
        double dy = obs.y - this.localX.y / this.localX.z;
        return dx * dx + dy * dy;
    }

    public void computeDistance(List<Point2D3D> data, double[] distance) {
        for (int i = 0; i < data.size(); ++i) {
            distance[i] = this.computeDistance(data.get(i));
        }
    }
}

